/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.math3.linear.RealVector;
import org.nlpub.watset.util.ContextSimilarity;
import org.nlpub.watset.util.Vectors;

public final class ContextSimilarities {
    private ContextSimilarities() {
        throw new AssertionError();
    }

    public static <V> ContextSimilarity<V> dummy() {
        return new DummyContextSimilarity();
    }

    public static <V> ContextSimilarity<V> cosine() {
        return new CosineContextSimilarity();
    }

    public static class CosineContextSimilarity<V>
    implements ContextSimilarity<V> {
        @Override
        public Number apply(Map<V, Number> bag1, Map<V, Number> bag2) {
            LinkedHashSet<V> union = new LinkedHashSet<V>(bag1.keySet());
            union.addAll(bag2.keySet());
            RealVector vec1 = Vectors.transform(bag1, union);
            RealVector vec2 = Vectors.transform(bag2, union);
            double norm1 = vec1.getNorm();
            double norm2 = vec2.getNorm();
            if (norm1 == 0.0 || norm2 == 0.0) {
                return 0.0;
            }
            return vec1.dotProduct(vec2) / (norm1 * norm2);
        }
    }

    public static class DummyContextSimilarity<V>
    implements ContextSimilarity<V> {
        @Override
        public Number apply(Map<V, Number> bag1, Map<V, Number> bag2) {
            return 0;
        }
    }
}

