/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.util.Iterator;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.graph.builder.GraphBuilder;

public final class Neighbors {
    private Neighbors() {
        throw new AssertionError();
    }

    public static <V, E> Iterator<V> neighborIterator(Graph<V, E> graph, V node) {
        return graph.edgesOf(node).stream().map(e -> Graphs.getOppositeVertex((Graph)graph, (Object)e, (Object)node)).iterator();
    }

    public static <V, E> Set<V> neighborSetOf(Graph<V, E> graph, V node) {
        return graph.edgesOf(node).stream().map(e -> Graphs.getOppositeVertex((Graph)graph, (Object)e, (Object)node)).collect(Collectors.toSet());
    }

    public static <V, E> Graph<V, E> neighborhoodGraph(Graph<V, E> graph, V node) {
        GraphBuilder builder = SimpleWeightedGraph.createBuilder((Supplier)graph.getEdgeSupplier());
        Set<V> neighborhood = Neighbors.neighborSetOf(graph, node);
        neighborhood.forEach(arg_0 -> ((GraphBuilder)builder).addVertex(arg_0));
        for (V neighbor : neighborhood) {
            for (Object edge : graph.edgesOf(neighbor)) {
                Object source = graph.getEdgeSource(edge);
                Object target = graph.getEdgeTarget(edge);
                if (!neighborhood.contains(source) || !neighborhood.contains(target)) continue;
                double weight = graph.getEdgeWeight(edge);
                builder.addEdge(source, target, edge, weight);
            }
        }
        return builder.buildAsUnmodifiable();
    }
}

