/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameters;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.cli.LocalWatsetCommand;
import org.nlpub.watset.graph.EmptyClustering;
import org.nlpub.watset.graph.SimplifiedWatset;
import org.nlpub.watset.graph.Watset;
import org.nlpub.watset.util.ClusteringAlgorithmProvider;
import org.nlpub.watset.util.IndexedSense;
import org.nlpub.watset.util.Sense;

@Parameters(commandDescription="Sense Induction")
class SensesCommand
extends LocalWatsetCommand {
    public SensesCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public void run() {
        Map<Sense<String>, Map<Sense<String>, Number>> contexts = this.getContexts(this.getAlgorithm(), this.getGraph());
        try {
            this.write(contexts);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Map<Sense<String>, Map<Sense<String>, Number>> getContexts(ClusteringAlgorithmProvider<String, DefaultWeightedEdge> algorithm, Graph<String, DefaultWeightedEdge> graph) {
        if (this.local.simplified) {
            SimplifiedWatset<String, DefaultWeightedEdge> watset = this.getSimplifiedWatset(algorithm, EmptyClustering.builder(), graph);
            ClusteringAlgorithm.Clustering clustering = watset.getClustering();
            return clustering.getContexts();
        }
        Watset<String, DefaultWeightedEdge> watset = this.getWatset(algorithm, EmptyClustering.builder(), graph);
        ClusteringAlgorithm.Clustering clustering = watset.getClustering();
        return clustering.getContexts();
    }

    private void write(Map<Sense<String>, Map<Sense<String>, Number>> contexts) throws IOException {
        try (BufferedWriter writer = this.newOutputWriter();){
            for (Map.Entry<Sense<String>, Map<Sense<String>, Number>> context : contexts.entrySet()) {
                IndexedSense sense = (IndexedSense)context.getKey();
                String contextRecord = context.getValue().entrySet().stream().map(e -> String.format(Locale.ROOT, "%s#%d:%f", ((Sense)e.getKey()).get(), ((IndexedSense)e.getKey()).getSense(), ((Number)e.getValue()).doubleValue())).collect(Collectors.joining(","));
                writer.write(String.format(Locale.ROOT, "%s\t%d\t%s%n", sense.get(), sense.getSense(), contextRecord));
            }
        }
    }
}

