/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameters;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.logging.Logger;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.cli.LocalWatsetCommand;
import org.nlpub.watset.graph.EmptyClustering;
import org.nlpub.watset.graph.SimplifiedWatset;
import org.nlpub.watset.graph.Watset;
import org.nlpub.watset.util.ClusteringAlgorithmProvider;
import org.nlpub.watset.util.IndexedSense;
import org.nlpub.watset.util.Sense;

@Parameters(commandDescription="Sense Graph")
class GraphCommand
extends LocalWatsetCommand {
    private static final Logger logger = Logger.getLogger(GraphCommand.class.getSimpleName());

    public GraphCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public void run() {
        this.notifySimplifiedWatset(logger, this.local.simplified);
        Graph<Sense<String>, DefaultWeightedEdge> senseGraph = this.getSenseGraph(this.getAlgorithm(), this.getGraph());
        try {
            this.write(senseGraph);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Graph<Sense<String>, DefaultWeightedEdge> getSenseGraph(ClusteringAlgorithmProvider<String, DefaultWeightedEdge> algorithm, Graph<String, DefaultWeightedEdge> graph) {
        if (this.local.simplified) {
            SimplifiedWatset<String, DefaultWeightedEdge> watset = this.getSimplifiedWatset(algorithm, EmptyClustering.builder(), graph);
            ClusteringAlgorithm.Clustering clustering = watset.getClustering();
            return clustering.getSenseGraph();
        }
        Watset<String, DefaultWeightedEdge> watset = this.getWatset(algorithm, EmptyClustering.builder(), graph);
        ClusteringAlgorithm.Clustering clustering = watset.getClustering();
        return clustering.getSenseGraph();
    }

    private void write(Graph<Sense<String>, DefaultWeightedEdge> graph) throws IOException {
        try (BufferedWriter writer = this.newOutputWriter();){
            for (DefaultWeightedEdge edge : graph.edgeSet()) {
                IndexedSense source = (IndexedSense)graph.getEdgeSource((Object)edge);
                IndexedSense target = (IndexedSense)graph.getEdgeTarget((Object)edge);
                writer.write(String.format(Locale.ROOT, "%s#%d\t%s#%d\t%f%n", source.get(), source.getSense(), target.get(), target.getSense(), graph.getEdgeWeight((Object)edge)));
            }
        }
    }
}

