/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import java.util.logging.Logger;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;
import org.nlpub.watset.graph.SimplifiedWatset;
import org.nlpub.watset.graph.Watset;
import org.nlpub.watset.util.Sense;

interface WatsetGetter<V, E> {
    default public void notifySimplifiedWatset(Logger logger, boolean simplified) {
        if (simplified) {
            logger.info("In the next version, Watset will always be simplified; get ready to remove the -s flag soon.");
        } else {
            logger.warning("In the next version, Simplified Watset will completely replace the regular Watset.");
        }
    }

    default public SimplifiedWatset<V, E> getSimplifiedWatset(ClusteringAlgorithmBuilder<V, E, ?> local, ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global, Graph<V, E> graph) {
        return SimplifiedWatset.builder().setLocal(local).setGlobal(global).apply(graph);
    }

    default public Watset<V, E> getWatset(ClusteringAlgorithmBuilder<V, E, ?> local, ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global, Graph<V, E> graph) {
        return Watset.builder().setLocal(local).setGlobal(global).apply(graph);
    }
}

