/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.commons.math3.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.util.VertexToIntegerMapping;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;

public class MarkovClustering<V, E>
implements ClusteringAlgorithm<V> {
    private static final Logger logger = Logger.getLogger(MarkovClustering.class.getSimpleName());
    protected final Graph<V, E> graph;
    protected final int e;
    protected final double r;
    protected final int iterations;
    protected ClusteringAlgorithm.Clustering<V> clustering;

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    public MarkovClustering(Graph<V, E> graph, int e, double r, int iterations) {
        this.graph = GraphTests.requireUndirected(graph);
        this.e = e;
        this.r = r;
        this.iterations = iterations;
    }

    public ClusteringAlgorithm.Clustering<V> getClustering() {
        if (Objects.isNull(this.clustering)) {
            this.clustering = new Implementation<V, E>(this.graph, this.e, this.r, this.iterations).compute();
        }
        return this.clustering;
    }

    public static class NormalizeVisitor
    extends DefaultRealMatrixChangingVisitor {
        private final RealMatrix sums;

        public NormalizeVisitor(RealMatrix sums) {
            this.sums = sums;
        }

        public double visit(int row, int column, double value) {
            return value / this.sums.getEntry(0, column);
        }
    }

    public static class InflateVisitor
    extends DefaultRealMatrixChangingVisitor {
        private final double r;

        public InflateVisitor(double r) {
            this.r = r;
        }

        public double visit(int row, int column, double value) {
            return StrictMath.pow(value, this.r);
        }
    }

    protected static class Implementation<V, E> {
        protected final Graph<V, E> graph;
        protected final int e;
        protected final int iterations;
        protected final InflateVisitor inflateVisitor;
        protected final VertexToIntegerMapping<V> mapping;
        protected final RealMatrix ones;
        protected RealMatrix matrix;

        public Implementation(Graph<V, E> graph, int e, double r, int iterations) {
            this.graph = graph;
            this.e = e;
            this.iterations = iterations;
            this.inflateVisitor = new InflateVisitor(r);
            this.mapping = Graphs.getVertexToIntegerMapping(graph);
            double[] onesData = new double[graph.vertexSet().size()];
            Arrays.fill(onesData, 1.0);
            this.ones = MatrixUtils.createRowRealMatrix((double[])onesData);
        }

        public ClusteringAlgorithm.Clustering<V> compute() {
            if (this.graph.vertexSet().isEmpty()) {
                return new ClusteringAlgorithm.ClusteringImpl(Collections.emptyList());
            }
            this.matrix = this.buildMatrix();
            this.normalize();
            for (int i = 0; i < this.iterations; ++i) {
                RealMatrix previous = this.matrix.copy();
                this.expand();
                this.inflate();
                if (this.matrix.equals(previous)) break;
            }
            ArrayList clusters = new ArrayList();
            for (int i = 0; i < this.matrix.getRowDimension(); ++i) {
                HashSet cluster = new HashSet();
                for (int j = 0; j < this.matrix.getColumnDimension(); ++j) {
                    if (!(this.matrix.getEntry(i, j) > 0.0)) continue;
                    cluster.add(this.mapping.getIndexList().get(j));
                }
                if (cluster.isEmpty()) continue;
                clusters.add(cluster);
            }
            return new ClusteringAlgorithm.ClusteringImpl(clusters);
        }

        protected RealMatrix buildMatrix() {
            if (this.graph.vertexSet().size() > 2048) {
                logger.warning(() -> String.format(Locale.ROOT, "Graph is large: %d nodes.", this.graph.vertexSet().size()));
            }
            RealMatrix matrix = MatrixUtils.createRealIdentityMatrix((int)this.graph.vertexSet().size());
            for (Object edge : this.graph.edgeSet()) {
                int j;
                int i = (Integer)this.mapping.getVertexMap().get(this.graph.getEdgeSource(edge));
                if (i == (j = ((Integer)this.mapping.getVertexMap().get(this.graph.getEdgeTarget(edge))).intValue())) continue;
                double weight = this.graph.getEdgeWeight(edge);
                matrix.setEntry(i, j, weight);
                matrix.setEntry(j, i, weight);
            }
            return matrix;
        }

        protected void normalize() {
            RealMatrix sums = this.ones.multiply(this.matrix);
            this.matrix.walkInOptimizedOrder((RealMatrixChangingVisitor)new NormalizeVisitor(sums));
        }

        protected void expand() {
            this.matrix = this.matrix.power(this.e);
        }

        protected void inflate() {
            this.normalize();
            this.matrix.walkInOptimizedOrder((RealMatrixChangingVisitor)this.inflateVisitor);
        }
    }

    public static class Builder<V, E>
    implements ClusteringAlgorithmBuilder<V, E, MarkovClustering<V, E>> {
        public static final int E = 2;
        public static final double R = 2.0;
        public static final int ITERATIONS = 20;
        private int e = 2;
        private double r = 2.0;
        private int iterations = 20;

        @Override
        public MarkovClustering<V, E> apply(Graph<V, E> graph) {
            return new MarkovClustering<V, E>(graph, this.e, this.r, this.iterations);
        }

        public Builder<V, E> setE(int e) {
            this.e = e;
            return this;
        }

        public Builder<V, E> setR(double r) {
            this.r = r;
            return this;
        }

        public Builder<V, E> setIterations(int iterations) {
            this.iterations = iterations;
            return this;
        }
    }
}

