/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.graph.AsUnmodifiableGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.graph.builder.GraphBuilder;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;
import org.nlpub.watset.graph.MaxMaxClustering;

public class MaxMax<V, E>
implements ClusteringAlgorithm<V> {
    private final Graph<V, E> graph;
    private MaxMaxClustering<V> clustering;

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    public MaxMax(Graph<V, E> graph) {
        this.graph = GraphTests.requireUndirected(graph);
    }

    public MaxMaxClustering<V> getClustering() {
        if (Objects.isNull(this.clustering)) {
            this.clustering = new Implementation<V, E>(this.graph).compute();
        }
        return this.clustering;
    }

    protected static class Implementation<V, E> {
        protected final Graph<V, E> graph;
        protected final Map<V, Set<V>> maximals;
        protected final Graph<V, DefaultEdge> digraph;
        protected final Map<V, Boolean> roots;

        public Implementation(Graph<V, E> graph) {
            this.graph = graph;
            this.maximals = new HashMap<V, Set<V>>(graph.vertexSet().size());
            this.roots = new HashMap<V, Boolean>(graph.vertexSet().size());
            GraphBuilder builder = SimpleDirectedGraph.createBuilder(DefaultEdge.class);
            for (Object node : graph.vertexSet()) {
                this.maximals.put(node, new HashSet());
                this.roots.put((Boolean)node, true);
                builder.addVertex(node);
            }
            this.digraph = builder.build();
        }

        public MaxMaxClustering<V> compute() {
            for (Object u : this.digraph.vertexSet()) {
                double max = this.graph.edgesOf(u).stream().mapToDouble(arg_0 -> this.graph.getEdgeWeight(arg_0)).max().orElse(-1.0);
                this.graph.edgesOf(u).stream().filter(e -> this.graph.getEdgeWeight(e) == max).map(e -> Graphs.getOppositeVertex(this.graph, (Object)e, (Object)u)).forEach(v -> this.maximals.get(u).add(v));
            }
            for (Object e2 : this.graph.edgeSet()) {
                Object u = this.graph.getEdgeSource(e2);
                Object v2 = this.graph.getEdgeTarget(e2);
                if (this.maximals.get(u).contains(v2)) {
                    this.digraph.addEdge(v2, u);
                }
                if (!this.maximals.get(v2).contains(u)) continue;
                this.digraph.addEdge(u, v2);
            }
            HashSet visited = new HashSet();
            for (Object v3 : this.digraph.vertexSet()) {
                if (!this.roots.get(v3).booleanValue()) continue;
                LinkedList queue = new LinkedList(Graphs.successorListOf(this.digraph, v3));
                visited.add(v3);
                while (!queue.isEmpty()) {
                    Object u = queue.remove();
                    if (visited.contains(u)) continue;
                    this.roots.put((Boolean)u, false);
                    visited.add(u);
                    queue.addAll(Graphs.successorListOf(this.digraph, u));
                }
            }
            List<Set<V>> clusters = this.extractClusters();
            return new MaxMaxClustering.MaxMaxClusteringImpl<V>(clusters, new AsUnmodifiableGraph(this.digraph), Collections.unmodifiableMap(this.maximals), Collections.unmodifiableMap(this.roots));
        }

        protected List<Set<V>> extractClusters() {
            Set rootNodes = this.roots.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
            return rootNodes.stream().map(root -> {
                HashSet cluster = new HashSet();
                LinkedList<Object> queue = new LinkedList<Object>();
                queue.add(root);
                while (!queue.isEmpty()) {
                    Object v = queue.remove();
                    if (cluster.contains(v)) continue;
                    cluster.add(v);
                    queue.addAll(Graphs.successorListOf(this.digraph, v));
                }
                return cluster;
            }).collect(Collectors.toList());
        }
    }

    public static class Builder<V, E>
    implements ClusteringAlgorithmBuilder<V, E, MaxMax<V, E>> {
        @Override
        public MaxMax<V, E> apply(Graph<V, E> graph) {
            return new MaxMax<V, E>(graph);
        }
    }
}

