/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.jgrapht.Graph;
import org.nlpub.watset.graph.NodeWeighting;

public final class NodeWeightings {
    private static final Logger logger = Logger.getLogger(NodeWeightings.class.getSimpleName());

    private NodeWeightings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static <V, E> NodeWeighting<V, E> label() {
        return new LabelNodeWeighting();
    }

    public static <V, E> NodeWeighting<V, E> top() {
        return new TopNodeWeighting();
    }

    public static <V, E> NodeWeighting<V, E> log() {
        return new LogNodeWeighting();
    }

    public static <V, E> NodeWeighting<V, E> linear() {
        return new LinearNodeWeighting();
    }

    public static <V, E> NodeWeighting<V, E> parse(String mode) {
        WeightingMode parsed = WeightingMode.valueOf(Objects.requireNonNullElse(mode, WeightingMode.TOP.name()).toUpperCase(Locale.ROOT));
        switch (parsed) {
            case LABEL: {
                return NodeWeightings.label();
            }
            case TOP: {
                return NodeWeightings.top();
            }
            case LOG: {
                return NodeWeightings.log();
            }
            case NOLOG: {
                logger.warning("Please update your code: 'nolog' weighting is renamed to 'lin'.");
                return NodeWeightings.linear();
            }
            case LIN: {
                return NodeWeightings.linear();
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + mode);
    }

    public static class LinearNodeWeighting<V, E>
    implements NodeWeighting<V, E> {
        @Override
        public double apply(Graph<V, E> graph, Map<V, Integer> labels, V node, V neighbor) {
            return graph.getEdgeWeight(graph.getEdge(node, neighbor)) / (double)graph.degreeOf(neighbor);
        }
    }

    public static class LogNodeWeighting<V, E>
    implements NodeWeighting<V, E> {
        @Override
        public double apply(Graph<V, E> graph, Map<V, Integer> labels, V node, V neighbor) {
            return graph.getEdgeWeight(graph.getEdge(node, neighbor)) / StrictMath.log1p(graph.degreeOf(neighbor));
        }
    }

    public static class TopNodeWeighting<V, E>
    implements NodeWeighting<V, E> {
        @Override
        public double apply(Graph<V, E> graph, Map<V, Integer> labels, V node, V neighbor) {
            return graph.getEdgeWeight(graph.getEdge(node, neighbor));
        }
    }

    public static class LabelNodeWeighting<V, E>
    implements NodeWeighting<V, E> {
        @Override
        public double apply(Graph<V, E> graph, Map<V, Integer> labels, V node, V neighbor) {
            return labels.get(node).intValue();
        }
    }

    public static enum WeightingMode {
        LABEL,
        TOP,
        LOG,
        NOLOG,
        LIN;

    }
}

