/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.graph.AsUnmodifiableGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.graph.builder.GraphBuilder;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;
import org.nlpub.watset.graph.SenseInduction;
import org.nlpub.watset.graph.WatsetClustering;
import org.nlpub.watset.util.ContextSimilarities;
import org.nlpub.watset.util.ContextSimilarity;
import org.nlpub.watset.util.IndexedSense;
import org.nlpub.watset.util.Sense;

@Deprecated
public class Watset<V, E>
implements ClusteringAlgorithm<V> {
    private static final Number DEFAULT_CONTEXT_WEIGHT = 1;
    private static final Logger logger = Logger.getLogger(Watset.class.getSimpleName());
    private final Graph<V, E> graph;
    private final ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global;
    private final ContextSimilarity<V> similarity;
    private final SenseInduction<V, E> inducer;
    private WatsetClustering<V> clustering;

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    public Watset(Graph<V, E> graph, ClusteringAlgorithmBuilder<V, E, ?> local, ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global, ContextSimilarity<V> similarity) {
        this.graph = GraphTests.requireUndirected(graph);
        this.global = Objects.requireNonNull(global);
        this.similarity = Objects.requireNonNull(similarity);
        this.inducer = new SenseInduction<V, E>(graph, Objects.requireNonNull(local));
    }

    public WatsetClustering<V> getClustering() {
        if (Objects.isNull(this.clustering)) {
            this.clustering = new Implementation<V, E>(this.graph, this.inducer, this.global, this.similarity).compute();
        }
        return this.clustering;
    }

    static class WatsetClusteringImpl<V>
    extends ClusteringAlgorithm.ClusteringImpl<V>
    implements WatsetClustering<V> {
        private final Map<V, Map<Sense<V>, Map<V, Number>>> inventory;
        private final Graph<Sense<V>, DefaultWeightedEdge> senseGraph;
        private final Map<Sense<V>, Map<Sense<V>, Number>> contexts;

        public WatsetClusteringImpl(List<Set<V>> clusters, Map<V, Map<Sense<V>, Map<V, Number>>> inventory, Graph<Sense<V>, DefaultWeightedEdge> senseGraph, Map<Sense<V>, Map<Sense<V>, Number>> contexts) {
            super(clusters);
            this.inventory = inventory;
            this.senseGraph = senseGraph;
            this.contexts = contexts;
        }

        public Map<V, Map<Sense<V>, Map<V, Number>>> getInventory() {
            return this.inventory;
        }

        @Override
        public Graph<Sense<V>, DefaultWeightedEdge> getSenseGraph() {
            return this.senseGraph;
        }

        @Override
        public Map<Sense<V>, Map<Sense<V>, Number>> getContexts() {
            return this.contexts;
        }
    }

    private static class Implementation<V, E> {
        private final Graph<V, E> graph;
        private final SenseInduction<V, E> inducer;
        private final ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global;
        private final ContextSimilarity<V> similarity;
        private final Map<V, Map<Sense<V>, Map<V, Number>>> inventory;

        private Implementation(Graph<V, E> graph, SenseInduction<V, E> inducer, ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global, ContextSimilarity<V> similarity) {
            this.graph = graph;
            this.inducer = inducer;
            this.global = global;
            this.similarity = similarity;
            this.inventory = new ConcurrentHashMap<V, Map<Sense<V>, Map<V, Number>>>(graph.vertexSet().size());
        }

        public WatsetClustering<V> compute() {
            logger.info("Watset started.");
            this.buildInventory();
            int senses = this.inventory.values().stream().mapToInt(Map::size).sum();
            logger.log(Level.INFO, "Watset: sense inventory constructed including {0} senses.", senses);
            Map<Sense<V>, Map<Sense<V>, Number>> contexts = this.buildContexts(senses);
            logger.info("Watset: contexts constructed.");
            Graph<Sense<V>, DefaultWeightedEdge> senseGraph = this.buildSenseGraph(contexts);
            if (this.graph.edgeSet().size() > senseGraph.edgeSet().size()) {
                throw new IllegalStateException("Mismatch in number of edges: expected at least " + this.graph.edgeSet().size() + ", but got " + senseGraph.edgeSet().size());
            }
            logger.info("Watset: sense graph constructed.");
            ClusteringAlgorithm globalAlgorithm = (ClusteringAlgorithm)this.global.apply(senseGraph);
            ClusteringAlgorithm.Clustering senseClusters = globalAlgorithm.getClustering();
            logger.info("Watset finished.");
            List clusters = senseClusters.getClusters().stream().map(cluster -> cluster.stream().map(Supplier::get).collect(Collectors.toSet())).collect(Collectors.toList());
            return new WatsetClusteringImpl(clusters, Collections.unmodifiableMap(this.inventory), new AsUnmodifiableGraph(senseGraph), Collections.unmodifiableMap(contexts));
        }

        private void buildInventory() {
            this.graph.vertexSet().parallelStream().forEach(node -> {
                List<Map<Object, Number>> senses = this.inducer.contexts(node);
                HashMap<IndexedSense<Object>, Map<Object, Number>> senseMap = new HashMap<IndexedSense<Object>, Map<Object, Number>>(senses.size());
                for (int i = 0; i < senses.size(); ++i) {
                    senseMap.put(new IndexedSense<Object>(node, i), senses.get(i));
                }
                this.inventory.put(node, senseMap);
            });
        }

        private Map<Sense<V>, Map<Sense<V>, Number>> buildContexts(int senses) {
            ConcurrentHashMap<Sense<V>, Map<Sense<V>, Number>> contexts = new ConcurrentHashMap<Sense<V>, Map<Sense<V>, Number>>(senses);
            this.inventory.entrySet().parallelStream().forEach(wordSenses -> {
                if (((Map)wordSenses.getValue()).isEmpty()) {
                    contexts.put(new IndexedSense(wordSenses.getKey(), 0), Collections.emptyMap());
                } else {
                    ((Map)wordSenses.getValue()).forEach((sense, context) -> contexts.put((Sense<V>)sense, this.disambiguateContext(this.inventory, (Sense<V>)sense)));
                }
            });
            return contexts;
        }

        private Map<Sense<V>, Number> disambiguateContext(Map<V, Map<Sense<V>, Map<V, Number>>> inventory, Sense<V> sense) {
            HashMap<Number, Number> context = new HashMap<Number, Number>(inventory.get(sense.get()).get(sense));
            context.put((Number)sense.get(), DEFAULT_CONTEXT_WEIGHT);
            return Sense.disambiguate(inventory, this.similarity, context, Collections.singleton(sense.get()));
        }

        private Graph<Sense<V>, DefaultWeightedEdge> buildSenseGraph(Map<Sense<V>, Map<Sense<V>, Number>> contexts) {
            GraphBuilder builder = SimpleWeightedGraph.createBuilder(DefaultWeightedEdge.class);
            contexts.keySet().forEach(arg_0 -> ((GraphBuilder)builder).addVertex(arg_0));
            contexts.forEach((source, context) -> context.forEach((target, weight) -> builder.addEdge(source, target, weight.doubleValue())));
            return builder.build();
        }
    }

    public static class Builder<V, E>
    implements ClusteringAlgorithmBuilder<V, E, Watset<V, E>> {
        private ClusteringAlgorithmBuilder<V, E, ?> local;
        private ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global;
        private ContextSimilarity<V> similarity = ContextSimilarities.cosine();

        @Override
        public Watset<V, E> apply(Graph<V, E> graph) {
            return new Watset<V, E>(graph, this.local, this.global, this.similarity);
        }

        public Builder<V, E> setLocal(ClusteringAlgorithmBuilder<V, E, ?> local) {
            this.local = Objects.requireNonNull(local);
            return this;
        }

        public Builder<V, E> setGlobal(ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global) {
            this.global = Objects.requireNonNull(global);
            return this;
        }

        public Builder<V, E> setSimilarity(ContextSimilarity<V> similarity) {
            this.similarity = Objects.requireNonNull(similarity);
            return this;
        }
    }
}

