/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.jgrapht.Graph;
import org.jgrapht.alg.clustering.KSpanningTreeClustering;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.nlpub.watset.graph.ChineseWhispers;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;
import org.nlpub.watset.graph.ComponentsClustering;
import org.nlpub.watset.graph.EmptyClustering;
import org.nlpub.watset.graph.MarkovClustering;
import org.nlpub.watset.graph.MarkovClusteringExternal;
import org.nlpub.watset.graph.MaxMax;
import org.nlpub.watset.graph.NodeWeighting;
import org.nlpub.watset.graph.NodeWeightings;
import org.nlpub.watset.graph.SingletonClustering;
import org.nlpub.watset.graph.TogetherClustering;

public class ClusteringAlgorithmProvider<V, E>
implements ClusteringAlgorithmBuilder<V, E, ClusteringAlgorithm<V>> {
    private final String algorithm;
    private final Map<String, String> params;
    private final NodeWeighting<V, E> weighting;
    private final Random random;

    public ClusteringAlgorithmProvider(String algorithm, Map<String, String> params, Random random) {
        this.algorithm = Objects.requireNonNull(algorithm, "algorithm is not specified");
        this.params = Objects.requireNonNullElse(params, Collections.emptyMap());
        this.weighting = NodeWeightings.parse(params.get("mode"));
        this.random = Objects.requireNonNullElse(random, new Random());
    }

    @Override
    public ClusteringAlgorithm<V> apply(Graph<V, E> graph) {
        switch (this.algorithm.toLowerCase(Locale.ROOT)) {
            case "empty": {
                return EmptyClustering.builder().apply(graph);
            }
            case "together": {
                return TogetherClustering.builder().apply(graph);
            }
            case "singleton": {
                return SingletonClustering.builder().apply(graph);
            }
            case "components": {
                return ComponentsClustering.builder().apply(graph);
            }
            case "kst": {
                int k = Integer.parseInt(Objects.requireNonNull(this.params.get("k"), "k must be specified"));
                return new KSpanningTreeClustering(graph, k);
            }
            case "cw": {
                return ChineseWhispers.builder().setWeighting(this.weighting).setRandom(this.random).apply(graph);
            }
            case "mcl": {
                MarkovClustering.Builder<V, E> mcl = MarkovClustering.builder();
                if (this.params.containsKey("e")) {
                    mcl.setE(Integer.parseInt(this.params.get("e")));
                }
                if (this.params.containsKey("r")) {
                    mcl.setR(Double.parseDouble(this.params.get("r")));
                }
                return mcl.apply(graph);
            }
            case "mcl-bin": {
                MarkovClusteringExternal.Builder<V, E> mclOfficial = MarkovClusteringExternal.builder().setPath(Path.of(this.params.get("bin"), new String[0])).setThreads(Runtime.getRuntime().availableProcessors());
                if (this.params.containsKey("r")) {
                    mclOfficial.setR(Double.parseDouble(this.params.get("r")));
                }
                return mclOfficial.apply(graph);
            }
            case "maxmax": {
                return MaxMax.builder().apply(graph);
            }
        }
        throw new IllegalArgumentException("Unknown algorithm: " + this.algorithm);
    }
}

