/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import java.util.logging.Logger;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;
import org.nlpub.watset.graph.SimplifiedWatset;
import org.nlpub.watset.util.Sense;

interface WatsetGetter<V, E> {
    default public void notifySimplifiedWatset(Logger logger, boolean simplified) {
        if (simplified) {
            logger.warning("Watset is always simplified; the -s flag makes no effect.");
        } else {
            logger.info("Simplified Watset is used instead of the regular Watset.");
        }
    }

    default public SimplifiedWatset<V, E> getWatset(ClusteringAlgorithmBuilder<V, E, ?> local, ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global, Graph<V, E> graph) {
        return SimplifiedWatset.builder().setLocal(local).setGlobal(global).apply(graph);
    }
}

