/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.eval;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgrapht.alg.util.Pair;
import org.nlpub.watset.eval.PrecisionRecall;

public class Pairwise<V> {
    public static <V> Set<Pair<V, V>> transform(Collection<Collection<V>> clusters) {
        return clusters.parallelStream().flatMap(Pairwise::combination).collect(Collectors.toSet());
    }

    public static <V> Stream<Pair<V, V>> combination(Collection<V> cluster) {
        return cluster.stream().flatMap(first -> cluster.stream().map(second -> Pairwise.pairOf(first, second))).filter(pair -> !pair.getFirst().equals(pair.getSecond()));
    }

    public static <V> Pair<V, V> pairOf(V first, V second) {
        return first.hashCode() <= second.hashCode() ? Pair.of(first, second) : Pair.of(second, first);
    }

    public PrecisionRecall evaluate(Collection<Collection<V>> clusters, Collection<Collection<V>> classes) {
        Set<Pair<V, V>> clusterPairs = Pairwise.transform(Objects.requireNonNull(clusters));
        Set<Pair<V, V>> classPairs = Pairwise.transform(Objects.requireNonNull(classes));
        HashSet<Pair<V, V>> union = new HashSet<Pair<V, V>>(clusterPairs);
        union.addAll(classPairs);
        boolean[] preds = new boolean[union.size()];
        boolean[] trues = new boolean[union.size()];
        int i = 0;
        for (Pair<V, V> pair : union) {
            preds[i] = clusterPairs.contains(pair);
            trues[i] = classPairs.contains(pair);
            ++i;
        }
        int tp = 0;
        int fp = 0;
        int fn = 0;
        for (i = 0; i < union.size(); ++i) {
            if (preds[i] && trues[i]) {
                ++tp;
            }
            if (preds[i] && !trues[i]) {
                ++fp;
            }
            if (preds[i] || !trues[i]) continue;
            ++fn;
        }
        double tp_fp = tp + fp;
        double tp_fn = tp + fn;
        return new PrecisionRecall(tp_fp == 0.0 ? 0.0 : (double)tp / tp_fp, tp_fn == 0.0 ? 0.0 : (double)tp / tp_fn);
    }
}

