/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;

public final class ILEFormat {
    public static final String SEPARATOR = "\t";
    public static final String DELIMITER = ", ";

    private ILEFormat() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void write(BufferedWriter writer, ClusteringAlgorithm.Clustering<String> clustering) {
        AtomicInteger counter = new AtomicInteger(0);
        clustering.getClusters().stream().sorted((smaller, larger) -> Integer.compare(larger.size(), smaller.size())).forEach(cluster -> {
            try {
                writer.write(String.format(Locale.ROOT, "%d%s%d%s%s%n", counter.incrementAndGet(), SEPARATOR, cluster.size(), SEPARATOR, String.join((CharSequence)DELIMITER, cluster)));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }
}

