/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Maximizer {
    private Maximizer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static <T> Predicate<T> alwaysTrue() {
        return o -> true;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return o -> false;
    }

    public static <V, S extends Comparable<S>> Optional<V> argmax(Iterator<V> it, Predicate<V> checker, Function<V, S> scorer) {
        Object result = null;
        Comparable score = null;
        while (it.hasNext()) {
            V current = it.next();
            if (!checker.test(current)) continue;
            Comparable currentScore = (Comparable)scorer.apply(current);
            if (!Objects.isNull(score) && currentScore.compareTo(score) <= 0) continue;
            result = current;
            score = currentScore;
        }
        return Optional.ofNullable(result);
    }

    public static <V, S extends Comparable<S>> Optional<V> argmax(Iterator<V> it, Function<V, S> scorer) {
        return Maximizer.argmax(it, Maximizer.alwaysTrue(), scorer);
    }

    public static <V, S extends Comparable<S>> Optional<V> argmaxRandom(Iterator<V> it, Function<V, S> scorer, Random random) {
        LinkedList<V> results = new LinkedList<V>();
        Comparable score = null;
        while (it.hasNext()) {
            int compare;
            V current = it.next();
            Comparable currentScore = (Comparable)scorer.apply(current);
            int n = compare = Objects.isNull(score) ? 1 : currentScore.compareTo(score);
            if (compare > 0) {
                results.clear();
                score = currentScore;
            }
            if (compare < 0) continue;
            results.add(current);
        }
        return results.isEmpty() ? Optional.empty() : Optional.of(results.get(random.nextInt(results.size())));
    }
}

