/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.JCommander;
import java.util.List;
import java.util.Objects;
import org.nlpub.watset.cli.ChineseWhispersCommand;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.cli.GraphCommand;
import org.nlpub.watset.cli.KSpanningTreeCommand;
import org.nlpub.watset.cli.MarkovClusteringCommand;
import org.nlpub.watset.cli.MarkovClusteringExternalCommand;
import org.nlpub.watset.cli.ProvidedClusteringCommand;
import org.nlpub.watset.cli.SensesCommand;
import org.nlpub.watset.cli.VersionCommand;
import org.nlpub.watset.cli.WatsetCommand;

public final class Application
implements Runnable {
    private final JCommander jc;
    private ParseStatus status = ParseStatus.EMPTY;

    public static void main(String[] args) {
        Application app = new Application();
        switch (app.parse(args)) {
            case COMMAND: 
            case EMPTY_BUT_VERSION: {
                app.run();
                break;
            }
            default: {
                app.jc.usage();
                System.exit(1);
            }
        }
    }

    public Application() {
        Command.MainParameters parameters = new Command.MainParameters();
        this.jc = JCommander.newBuilder().addObject((Object)parameters).addCommand("empty", (Object)new ProvidedClusteringCommand(parameters, "empty"), new String[0]).addCommand("singleton", (Object)new ProvidedClusteringCommand(parameters, "singleton"), new String[0]).addCommand("together", (Object)new ProvidedClusteringCommand(parameters, "together"), new String[0]).addCommand("components", (Object)new ProvidedClusteringCommand(parameters, "components"), new String[0]).addCommand("kst", (Object)new KSpanningTreeCommand(parameters), new String[0]).addCommand("cw", (Object)new ChineseWhispersCommand(parameters), new String[0]).addCommand("mcl", (Object)new MarkovClusteringCommand(parameters), new String[0]).addCommand("mcl-bin", (Object)new MarkovClusteringExternalCommand(parameters), new String[0]).addCommand("senses", (Object)new SensesCommand(parameters), new String[0]).addCommand("graph", (Object)new GraphCommand(parameters), new String[0]).addCommand("watset", (Object)new WatsetCommand(parameters), new String[0]).addCommand("maxmax", (Object)new ProvidedClusteringCommand(parameters, "maxmax"), new String[0]).addCommand("version", (Object)new VersionCommand(parameters), new String[0]).build();
    }

    public ParseStatus parse(String ... args) {
        this.status = ParseStatus.EMPTY;
        this.jc.parse(args);
        Command.MainParameters parameters = (Command.MainParameters)this.jc.getObjects().get(0);
        if (Objects.nonNull(this.jc.getParsedCommand())) {
            this.status = ParseStatus.COMMAND;
        } else if (parameters.version) {
            this.status = ParseStatus.EMPTY_BUT_VERSION;
        }
        return this.status;
    }

    @Override
    public void run() {
        String command = this.status == ParseStatus.EMPTY_BUT_VERSION ? "version" : Objects.requireNonNull(this.jc.getParsedCommand(), "command should not be null");
        this.run(command);
    }

    public void run(String command) {
        List objects = ((JCommander)this.jc.getCommands().get(command)).getObjects();
        Command runnable = (Command)objects.get(0);
        runnable.run();
    }

    public static enum ParseStatus {
        COMMAND,
        EMPTY,
        EMPTY_BUT_VERSION;

    }
}

