/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Maximizer {
    private Maximizer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static <T> Predicate<T> alwaysTrue() {
        return o -> true;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return o -> false;
    }

    public static <V, S extends Comparable<S>> Optional<V> argmax(Iterable<V> iterable, Predicate<V> checker, Function<V, S> scorer) {
        Object result = null;
        Comparable score = null;
        for (V current : iterable) {
            if (!checker.test(current)) continue;
            Comparable currentScore = (Comparable)scorer.apply(current);
            if (!Objects.isNull(score) && currentScore.compareTo(score) <= 0) continue;
            result = current;
            score = currentScore;
        }
        return Optional.ofNullable(result);
    }

    public static <V, S extends Comparable<S>> Optional<V> argmax(Iterable<V> iterable, Function<V, S> scorer) {
        return Maximizer.argmax(iterable, Maximizer.alwaysTrue(), scorer);
    }

    public static <V, S extends Comparable<S>> Optional<V> argrandmax(Iterable<V> iterable, Function<V, S> scorer, Random random) {
        LinkedList<V> results = new LinkedList<V>();
        Comparable score = null;
        for (V current : iterable) {
            int compare;
            Comparable currentScore = (Comparable)scorer.apply(current);
            int n = compare = Objects.isNull(score) ? 1 : currentScore.compareTo(score);
            if (compare > 0) {
                results.clear();
                score = currentScore;
            }
            if (compare < 0) continue;
            results.add(current);
        }
        return results.isEmpty() ? Optional.empty() : Optional.of(results.get(random.nextInt(results.size())));
    }
}

