/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.nio.file.Path;
import java.util.Objects;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.ClusteringCommand;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.graph.MarkovClusteringExternal;

@Parameters(commandDescription="Markov Clustering Official Binary")
class MarkovClusteringExternalCommand
extends ClusteringCommand {
    @Parameter(description="Inflation parameter", names={"-r"})
    private double r = 2.0;
    @Parameter(description="Path to binary mcl", names={"--bin"})
    private Path binary;

    public MarkovClusteringExternalCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public ClusteringAlgorithm<String> getAlgorithm() {
        MarkovClusteringExternal.Builder<String, DefaultWeightedEdge> builder = MarkovClusteringExternal.builder().setR(this.r);
        if (Objects.nonNull(this.binary)) {
            builder.setPath(this.binary);
        }
        return builder.apply(this.getGraph());
    }
}

