/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math3.linear.RealVector;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.util.VertexToIntegerMapping;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;
import org.nlpub.watset.util.Matrices;

public class MarkovClustering<V, E>
implements ClusteringAlgorithm<V> {
    protected final Graph<V, E> graph;
    protected final int e;
    protected final double r;
    protected final int iterations;
    protected ClusteringAlgorithm.Clustering<V> clustering;

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    public MarkovClustering(Graph<V, E> graph, int e, double r, int iterations) {
        this.graph = GraphTests.requireUndirected(graph);
        this.e = e;
        this.r = r;
        this.iterations = iterations;
    }

    public ClusteringAlgorithm.Clustering<V> getClustering() {
        if (Objects.isNull(this.clustering)) {
            this.clustering = new Implementation<V, E>(this.graph, this.e, this.r, this.iterations).compute();
        }
        return this.clustering;
    }

    protected static class Implementation<V, E> {
        protected final Graph<V, E> graph;
        protected final int e;
        protected final int iterations;
        protected final Matrices.InflateVisitor inflateVisitor;
        protected final VertexToIntegerMapping<V> mapping;
        protected RealMatrix matrix;

        public Implementation(Graph<V, E> graph, int e, double r, int iterations) {
            this.graph = graph;
            this.e = e;
            this.iterations = iterations;
            this.inflateVisitor = new Matrices.InflateVisitor(r);
            this.mapping = Graphs.getVertexToIntegerMapping(graph);
        }

        public ClusteringAlgorithm.Clustering<V> compute() {
            if (this.graph.vertexSet().isEmpty()) {
                return new ClusteringAlgorithm.ClusteringImpl(Collections.emptyList());
            }
            this.matrix = Matrices.buildAdjacencyMatrix(this.graph, this.mapping, true);
            this.normalize();
            for (int i = 0; i < this.iterations; ++i) {
                RealMatrix previous = this.matrix.copy();
                this.expand();
                this.inflate();
                if (this.matrix.equals(previous)) break;
            }
            ArrayList clusters = new ArrayList();
            for (int i = 0; i < this.matrix.getRowDimension(); ++i) {
                HashSet cluster = new HashSet();
                for (int j = 0; j < this.matrix.getColumnDimension(); ++j) {
                    if (!(this.matrix.getEntry(i, j) > 0.0)) continue;
                    cluster.add(this.mapping.getIndexList().get(j));
                }
                if (cluster.isEmpty()) continue;
                clusters.add(cluster);
            }
            return new ClusteringAlgorithm.ClusteringImpl(clusters);
        }

        protected void normalize() {
            ArrayRealVector sums = new ArrayRealVector(this.matrix.getColumnDimension());
            this.matrix.walkInOptimizedOrder((RealMatrixPreservingVisitor)new Matrices.ColumnSumVisitor((RealVector)sums));
            this.matrix.walkInOptimizedOrder((RealMatrixChangingVisitor)new Matrices.ColumnNormalizeVisitor((RealVector)sums));
        }

        protected void expand() {
            this.matrix = this.matrix.power(this.e);
        }

        protected void inflate() {
            this.normalize();
            this.matrix.walkInOptimizedOrder((RealMatrixChangingVisitor)this.inflateVisitor);
        }
    }

    public static class Builder<V, E>
    implements ClusteringAlgorithmBuilder<V, E, MarkovClustering<V, E>> {
        public static final int E = 2;
        public static final double R = 2.0;
        public static final int ITERATIONS = 20;
        private int e = 2;
        private double r = 2.0;
        private int iterations = 20;

        @Override
        public MarkovClustering<V, E> apply(Graph<V, E> graph) {
            return new MarkovClustering<V, E>(graph, this.e, this.r, this.iterations);
        }

        public Builder<V, E> setE(int e) {
            this.e = e;
            return this;
        }

        public Builder<V, E> setR(double r) {
            this.r = r;
            return this;
        }

        public Builder<V, E> setIterations(int iterations) {
            this.iterations = iterations;
            return this;
        }
    }
}

