/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.util.VertexToIntegerMapping;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;

public class MarkovClusteringExternal<V, E>
implements ClusteringAlgorithm<V> {
    private static final Logger logger = Logger.getLogger(MarkovClusteringExternal.class.getSimpleName());
    protected final Graph<V, E> graph;
    protected final Path path;
    protected final double r;
    protected final int threads;
    protected ClusteringAlgorithm.Clustering<V> clustering;

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    public MarkovClusteringExternal(Graph<V, E> graph, Path path, double r, int threads) {
        this.graph = GraphTests.requireUndirected(graph);
        this.path = Objects.requireNonNull(path);
        this.r = r;
        this.threads = threads;
    }

    public ClusteringAlgorithm.Clustering<V> getClustering() {
        if (Objects.isNull(this.clustering)) {
            this.clustering = new Implementation<V, E>(this.graph, this.path, this.r, this.threads).compute();
        }
        return this.clustering;
    }

    public static class Implementation<V, E> {
        protected final Graph<V, E> graph;
        protected final Path path;
        protected final double r;
        protected final int threads;
        protected final VertexToIntegerMapping<V> mapping;
        protected File output;

        public Implementation(Graph<V, E> graph, Path path, double r, int threads) {
            this.graph = graph;
            this.path = path;
            this.r = r;
            this.threads = threads;
            this.mapping = Graphs.getVertexToIntegerMapping(graph);
        }

        public ClusteringAlgorithm.Clustering<V> compute() {
            ClusteringAlgorithm.ClusteringImpl clusteringImpl;
            block10: {
                logger.info("Preparing for Markov Clustering.");
                try {
                    this.process();
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                logger.info("Markov Clustering finished.");
                Stream<String> stream = Files.lines(this.output.toPath());
                try {
                    List clusters = stream.map(line -> Arrays.stream(line.split("\t")).map(id -> this.mapping.getIndexList().get(Integer.parseInt(id))).collect(Collectors.toSet())).collect(Collectors.toList());
                    clusteringImpl = new ClusteringAlgorithm.ClusteringImpl(clusters);
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException("Clusters cannot be read.", ex);
                    }
                }
                stream.close();
            }
            return clusteringImpl;
        }

        protected void process() throws IOException {
            int status;
            this.output = File.createTempFile("mcl", "output");
            this.output.deleteOnExit();
            File input = this.writeInputFile();
            ProcessBuilder builder = new ProcessBuilder(this.path.toAbsolutePath().toString(), input.toString(), "-I", Double.toString(this.r), "-te", Integer.toString(this.threads), "--abc", "-o", this.output.toString());
            logger.info(() -> "Command: " + String.join((CharSequence)" ", builder.command()));
            Process process = builder.start();
            try {
                status = process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(this.path.toAbsolutePath() + " has been interrupted", e);
            }
            if (status != 0) {
                InputStreamReader isr = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
                try {
                    BufferedReader reader = new BufferedReader(isr);
                    try {
                        String stderr = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                        if (stderr.isEmpty()) {
                            throw new IllegalStateException(this.path.toAbsolutePath() + " returned " + status);
                        }
                        throw new IllegalStateException(this.path.toAbsolutePath() + " returned " + status + ": " + stderr);
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        isr.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }

        protected File writeInputFile() throws IOException {
            File input = File.createTempFile("mcl", "input");
            input.deleteOnExit();
            try (BufferedWriter writer = Files.newBufferedWriter(input.toPath(), new OpenOption[0]);){
                for (Object edge : this.graph.edgeSet()) {
                    int source = (Integer)this.mapping.getVertexMap().get(this.graph.getEdgeSource(edge));
                    int target = (Integer)this.mapping.getVertexMap().get(this.graph.getEdgeTarget(edge));
                    double weight = this.graph.getEdgeWeight(edge);
                    writer.write(String.format(Locale.ROOT, "%d\t%d\t%f%n", source, target, weight));
                }
            }
            return input;
        }
    }

    public static class Builder<V, E>
    implements ClusteringAlgorithmBuilder<V, E, MarkovClusteringExternal<V, E>> {
        public static final int R = 2;
        public static final int THREADS = 1;
        private Path path;
        private double r = 2.0;
        private int threads = 1;

        @Override
        public MarkovClusteringExternal<V, E> apply(Graph<V, E> graph) {
            return new MarkovClusteringExternal<V, E>(graph, this.path, this.r, this.threads);
        }

        public Builder<V, E> setPath(Path path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        public Builder<V, E> setR(double r) {
            this.r = r;
            return this;
        }

        public Builder<V, E> setThreads(int threads) {
            this.threads = threads;
            return this;
        }
    }
}

