/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Set;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;

public final class ILEFormat {
    public static final String SEPARATOR = "\t";
    public static final String DELIMITER = ", ";

    private ILEFormat() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void write(BufferedWriter writer, ClusteringAlgorithm.Clustering<String> clustering) throws IOException {
        Iterable clusters = () -> clustering.getClusters().stream().sorted((smaller, larger) -> Integer.compare(larger.size(), smaller.size())).iterator();
        int counter = 0;
        for (Set cluster : clusters) {
            writer.write(Integer.toString(++counter));
            writer.write(SEPARATOR);
            writer.write(Integer.toString(cluster.size()));
            writer.write(SEPARATOR);
            writer.write(String.join((CharSequence)DELIMITER, cluster));
            writer.write(System.lineSeparator());
        }
    }
}

