/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.cli.EvaluateCommand;
import org.nlpub.watset.eval.NormalizedModifiedPurity;
import org.nlpub.watset.eval.PrecisionRecall;

@Parameters(commandDescription="Cluster Evaluation with Purity")
class PurityCommand
extends EvaluateCommand {
    @Parameter(names={"-n", "--normalized"}, description="Use normalized purity")
    public boolean normalized;
    @Parameter(names={"-m", "--modified"}, description="Use modified purity")
    public boolean modified;

    public PurityCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public void run() {
        List clusters = this.transform(this.getClusters());
        List classes = this.transform(this.getClasses());
        NormalizedModifiedPurity precision = new NormalizedModifiedPurity(this.normalized, this.modified);
        NormalizedModifiedPurity recall = new NormalizedModifiedPurity(this.normalized, false);
        PrecisionRecall results = NormalizedModifiedPurity.evaluate(precision, recall, clusters, classes);
        try (BufferedWriter writer = this.newOutputWriter();){
            writer.write(String.format(Locale.ROOT, "Clusters: %d", clusters.size()));
            writer.write(System.lineSeparator());
            writer.write(String.format(Locale.ROOT, "Classes: %d", classes.size()));
            writer.write(System.lineSeparator());
            if (this.normalized && this.modified) {
                writer.write(String.format(Locale.ROOT, "nmPU: %f", results.getPrecision()));
            } else if (this.normalized) {
                writer.write(String.format(Locale.ROOT, "nPU: %f", results.getPrecision()));
            } else if (this.modified) {
                writer.write(String.format(Locale.ROOT, "mPU: %f", results.getPrecision()));
            } else {
                writer.write(String.format(Locale.ROOT, "PU: %f", results.getPrecision()));
            }
            writer.write(System.lineSeparator());
            if (this.normalized) {
                writer.write(String.format(Locale.ROOT, "niPU: %f", results.getRecall()));
            } else {
                writer.write(String.format(Locale.ROOT, "iPU: %f", results.getRecall()));
            }
            writer.write(System.lineSeparator());
            writer.write(String.format(Locale.ROOT, "F1: %f", results.getF1Score()));
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private List<Map<String, Double>> transform(ClusteringAlgorithm.Clustering<String> clustering) {
        List<Map<String, Double>> transformed = NormalizedModifiedPurity.transform(clustering.getClusters());
        return this.normalized ? NormalizedModifiedPurity.normalize(transformed) : transformed;
    }
}

