/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.util.VertexToIntegerMapping;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.cli.LocalWatsetCommand;
import org.nlpub.watset.graph.EmptyClustering;
import org.nlpub.watset.graph.Watset;
import org.nlpub.watset.util.Matrices;
import org.nlpub.watset.util.Word2VecFormat;

@Parameters(commandDescription="Sense Graph Embeddings")
class SenseEmbeddingCommand
extends LocalWatsetCommand {
    @ParametersDelegate
    public Command.FixedClustersParameters fixed = new Command.FixedClustersParameters();

    public SenseEmbeddingCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public void run() {
        Watset<String, DefaultWeightedEdge> watset = this.getWatset(this.getAlgorithm(), EmptyClustering.builder(), this.getGraph());
        Graph graph = watset.getClustering().getSenseGraph();
        VertexToIntegerMapping mapping = Graphs.getVertexToIntegerMapping(graph);
        List embedding = Matrices.computeSpectralEmbedding(graph, mapping, (int)this.fixed.k);
        try (BufferedWriter writer = this.newOutputWriter();){
            Word2VecFormat.write(writer, embedding, Word2VecFormat.SpaceStrategy.REPLACE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

