/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.math3.ml.clustering.Clusterer;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.util.VertexToIntegerMapping;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;
import org.nlpub.watset.graph.NodeEmbedding;
import org.nlpub.watset.util.Matrices;

public class SpectralClustering<V, E>
implements ClusteringAlgorithm<V> {
    private final Graph<V, E> graph;
    private final Clusterer<NodeEmbedding<V>> clusterer;
    private final int k;
    private ClusteringAlgorithm.Clustering<V> clustering;

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    public SpectralClustering(Graph<V, E> graph, Clusterer<NodeEmbedding<V>> clusterer, int k) {
        this.graph = GraphTests.requireUndirected(graph);
        this.clusterer = clusterer;
        this.k = k;
    }

    public ClusteringAlgorithm.Clustering<V> getClustering() {
        if (Objects.isNull(this.clustering)) {
            this.clustering = new Implementation<V, E>(this.graph, this.clusterer, this.k).compute();
        }
        return this.clustering;
    }

    public static class Implementation<V, E> {
        protected final Clusterer<NodeEmbedding<V>> clusterer;
        protected final VertexToIntegerMapping<V> mapping;
        protected final List<NodeEmbedding<V>> embeddings;

        public Implementation(Graph<V, E> graph, Clusterer<NodeEmbedding<V>> clusterer, int k) {
            this.clusterer = clusterer;
            this.mapping = Graphs.getVertexToIntegerMapping(graph);
            this.embeddings = Matrices.computeSpectralEmbedding(graph, this.mapping, k);
        }

        public ClusteringAlgorithm.Clustering<V> compute() {
            List clusters = this.clusterer.cluster(this.embeddings);
            return new ClusteringAlgorithm.ClusteringImpl(clusters.stream().map(cluster -> cluster.getPoints().stream().map(NodeEmbedding::get).collect(Collectors.toSet())).collect(Collectors.toList()));
        }
    }

    public static class Builder<V, E>
    implements ClusteringAlgorithmBuilder<V, E, SpectralClustering<V, E>> {
        private Clusterer<NodeEmbedding<V>> clusterer;
        private Integer k;

        public Builder<V, E> setClusterer(Clusterer<NodeEmbedding<V>> clusterer) {
            this.clusterer = clusterer;
            return this;
        }

        public Builder<V, E> setK(int k) {
            this.k = k;
            return this;
        }

        @Override
        public SpectralClustering<V, E> apply(Graph<V, E> graph) {
            return new SpectralClustering<V, E>(graph, this.clusterer, Objects.requireNonNull(this.k, "k must be specified"));
        }
    }
}

