/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.graph.AsUnmodifiableGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.graph.builder.GraphBuilder;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;
import org.nlpub.watset.graph.SenseInduction;
import org.nlpub.watset.graph.WatsetClustering;
import org.nlpub.watset.util.IndexedSense;
import org.nlpub.watset.util.Sense;

public class Watset<V, E>
implements ClusteringAlgorithm<V> {
    private static final System.Logger logger = System.getLogger(Watset.class.getSimpleName());
    protected final Graph<V, E> graph;
    protected final SenseInduction<V, E> inducer;
    protected final ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global;
    protected WatsetClustering<V> clustering;

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    public Watset(Graph<V, E> graph, ClusteringAlgorithmBuilder<V, E, ?> local, ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global) {
        this.graph = GraphTests.requireUndirected(graph);
        this.inducer = new SenseInduction<V, E>(graph, Objects.requireNonNull(local));
        this.global = Objects.requireNonNull(global);
    }

    public WatsetClustering<V> getClustering() {
        if (Objects.isNull(this.clustering)) {
            this.clustering = new Implementation<V, E>(this.graph, this.inducer, this.global).compute();
        }
        return this.clustering;
    }

    public static class Implementation<V, E> {
        protected final Graph<V, E> graph;
        protected final SenseInduction<V, E> inducer;
        protected final ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global;
        protected final Map<V, Map<V, Integer>> inventory;
        protected final Map<V, List<Sense<V>>> senses;

        public Implementation(Graph<V, E> graph, SenseInduction<V, E> inducer, ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global) {
            this.graph = graph;
            this.inducer = inducer;
            this.global = global;
            this.inventory = new ConcurrentHashMap<V, Map<V, Integer>>(graph.vertexSet().size());
            this.senses = new ConcurrentHashMap<V, List<Sense<V>>>(graph.vertexSet().size());
        }

        public WatsetClustering<V> compute() {
            logger.log(System.Logger.Level.INFO, "Watset started.");
            this.buildInventory();
            int count = this.senses.values().stream().mapToInt(List::size).sum();
            logger.log(System.Logger.Level.INFO, "Watset: sense inventory constructed including {0} senses.", count);
            Graph<Sense<V>, DefaultWeightedEdge> senseGraph = this.buildSenseGraph();
            if (this.graph.edgeSet().size() != senseGraph.edgeSet().size()) {
                throw new IllegalStateException("Mismatch in number of edges: expected " + this.graph.edgeSet().size() + ", but got " + senseGraph.edgeSet().size());
            }
            logger.log(System.Logger.Level.INFO, "Watset: sense graph constructed.");
            ClusteringAlgorithm globalAlgorithm = (ClusteringAlgorithm)this.global.apply(senseGraph);
            ClusteringAlgorithm.Clustering senseClusters = globalAlgorithm.getClustering();
            logger.log(System.Logger.Level.INFO, "Watset finished.");
            List clusters = senseClusters.getClusters().stream().map(cluster -> cluster.stream().map(Supplier::get).collect(Collectors.toSet())).collect(Collectors.toList());
            return new WatsetClustering.WatsetClusteringImpl(clusters, Collections.unmodifiableMap(this.inventory), new AsUnmodifiableGraph(senseGraph));
        }

        protected void buildInventory() {
            this.graph.vertexSet().parallelStream().forEach(node -> {
                ClusteringAlgorithm.Clustering<Object> clustering = this.inducer.clustering(node);
                if (Objects.nonNull(this.inventory.put(node, new HashMap()))) {
                    throw new IllegalStateException("The target node is already in the inventory");
                }
                if (Objects.nonNull(this.senses.put(node, new ArrayList(clustering.getNumberClusters())))) {
                    throw new IllegalStateException("The target node is already in the sense index");
                }
                if (clustering.getNumberClusters() == 0) {
                    this.senses.get(node).add(new IndexedSense<Object>(node, 0));
                }
                int i = 0;
                for (Set cluster : clustering) {
                    this.senses.get(node).add(i, new IndexedSense<Object>(node, i));
                    for (Object neighbor : cluster) {
                        this.inventory.get(node).put((Integer)neighbor, i);
                    }
                    ++i;
                }
            });
        }

        protected Graph<Sense<V>, DefaultWeightedEdge> buildSenseGraph() {
            GraphBuilder builder = SimpleWeightedGraph.createBuilder(DefaultWeightedEdge.class);
            for (Map.Entry<V, Map<V, Integer>> sourceEntry : this.inventory.entrySet()) {
                if (sourceEntry.getValue().isEmpty()) {
                    builder.addVertex(new IndexedSense<V>(sourceEntry.getKey(), 0));
                }
                V source = sourceEntry.getKey();
                for (V target : sourceEntry.getValue().keySet()) {
                    Sense<V> sourceSense = Objects.requireNonNull(this.senses.get(source).get(this.inventory.get(source).get(target)));
                    Sense<V> targetSense = Objects.requireNonNull(this.senses.get(target).get(this.inventory.get(target).get(source)));
                    Object edge = Objects.requireNonNull(this.graph.getEdge(source, target));
                    double weight = this.graph.getEdgeWeight(edge);
                    builder.addEdge(sourceSense, targetSense, weight);
                }
            }
            return builder.build();
        }
    }

    public static class Builder<V, E>
    implements ClusteringAlgorithmBuilder<V, E, Watset<V, E>> {
        private ClusteringAlgorithmBuilder<V, E, ?> local;
        private ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global;

        @Override
        public Watset<V, E> apply(Graph<V, E> graph) {
            return new Watset<V, E>(graph, this.local, this.global);
        }

        public Builder<V, E> setLocal(ClusteringAlgorithmBuilder<V, E, ?> local) {
            this.local = Objects.requireNonNull(local);
            return this;
        }

        public Builder<V, E> setGlobal(ClusteringAlgorithmBuilder<Sense<V>, DefaultWeightedEdge, ?> global) {
            this.global = Objects.requireNonNull(global);
            return this;
        }
    }
}

