/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.nlpub.watset.cli.ClusteringCommand;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.graph.ChineseWhispers;
import org.nlpub.watset.graph.NodeWeightings;

@Parameters(commandDescription="Chinese Whispers")
class ChineseWhispersCommand
extends ClusteringCommand {
    @Parameter(description="Node weighting mode (top, log, lin)", names={"-m", "--mode"})
    private String mode = NodeWeightings.WeightingMode.TOP.name();
    @Parameter(description="Number of iterations", names={"-n", "--iterations"})
    private int iterations = 20;

    public ChineseWhispersCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public ClusteringAlgorithm<String> getAlgorithm() {
        return ChineseWhispers.builder().setWeighting(NodeWeightings.parse(this.mode)).setIterations(this.iterations).setRandom(this.parameters.random).apply(this.getGraph());
    }
}

