/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.util.ILEFormat;

abstract class ClusteringCommand
extends Command {
    protected ClusteringCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public void run() {
        ClusteringAlgorithm<String> algorithm = this.getAlgorithm();
        ClusteringAlgorithm.Clustering<String> clustering = algorithm.getClustering();
        try (BufferedWriter writer = this.newOutputWriter();){
            ILEFormat.write(writer, clustering);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public abstract ClusteringAlgorithm<String> getAlgorithm();
}

