/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.util.VertexToIntegerMapping;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.util.Matrices;
import org.nlpub.watset.util.Word2VecFormat;

@Parameters(commandDescription="Graph Embeddings")
class EmbeddingCommand
extends Command {
    @ParametersDelegate
    public Command.FixedClustersParameters fixed = new Command.FixedClustersParameters();

    public EmbeddingCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public void run() {
        Graph<String, DefaultWeightedEdge> graph = this.getGraph();
        VertexToIntegerMapping<String> mapping = Graphs.getVertexToIntegerMapping(graph);
        List embedding = Matrices.computeSpectralEmbedding(graph, mapping, (int)this.fixed.k);
        try (BufferedWriter writer = this.newOutputWriter();){
            Word2VecFormat.write(writer, embedding, Word2VecFormat.SpaceStrategy.REPLACE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

