/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.clustering.MultiKMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.nlpub.watset.cli.ClusteringCommand;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.graph.SpectralClustering;

@Parameters(commandDescription="Spectral Clustering")
class SpectralClusteringCommand
extends ClusteringCommand {
    @ParametersDelegate
    public Command.FixedClustersParameters fixed = new Command.FixedClustersParameters();
    @Parameter(description="Number of k-means runs", names={"-n"})
    public int n = 10;

    public SpectralClusteringCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public ClusteringAlgorithm<String> getAlgorithm() {
        KMeansPlusPlusClusterer clusterer = new KMeansPlusPlusClusterer(this.fixed.k, -1, new EuclideanDistance(), this.parameters.random);
        MultiKMeansPlusPlusClusterer metaClusterer = new MultiKMeansPlusPlusClusterer(clusterer, this.n);
        return SpectralClustering.builder().setClusterer(metaClusterer).setK(this.fixed.k).apply(this.getGraph());
    }
}

