/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.graph.AsUnmodifiableGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;
import org.nlpub.watset.graph.MaxMaxClustering;

public class MaxMax<V, E>
implements ClusteringAlgorithm<V> {
    private final Graph<V, E> graph;
    private MaxMaxClustering<V> clustering;

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    public MaxMax(Graph<V, E> graph) {
        this.graph = GraphTests.requireWeighted(GraphTests.requireUndirected(graph));
        if (!GraphTests.isSimple(graph)) {
            throw new IllegalArgumentException("Graph must be simple");
        }
    }

    @Override
    public MaxMaxClustering<V> getClustering() {
        if (Objects.isNull(this.clustering)) {
            this.clustering = new Implementation<V, E>(this.graph).compute();
        }
        return this.clustering;
    }

    protected static class Implementation<V, E> {
        protected final Graph<V, E> graph;
        protected final Map<V, Double> weights;
        protected final Graph<V, DefaultEdge> digraph;

        public Implementation(Graph<V, E> graph) {
            this.graph = graph;
            this.weights = new HashMap<V, Double>(graph.vertexSet().size());
            this.digraph = SimpleDirectedGraph.createBuilder(DefaultEdge.class).build();
        }

        public MaxMaxClustering<V> compute() {
            this.computeWeights();
            this.buildArcs();
            Map<V, Set<V>> clusters = this.extractClusters();
            long elements = clusters.values().stream().flatMap(Collection::stream).distinct().count();
            if (elements != (long)this.graph.vertexSet().size()) {
                throw new IllegalStateException("Clusters do not cover the nodes: " + elements + " vs. " + this.graph.vertexSet().size());
            }
            return new MaxMaxClustering.MaxMaxClusteringImpl<V>(List.copyOf(clusters.values()), new AsUnmodifiableGraph<V, DefaultEdge>(this.digraph), Collections.unmodifiableSet(clusters.keySet()));
        }

        private void computeWeights() {
            for (E edge : this.graph.edgeSet()) {
                V u = this.graph.getEdgeSource(edge);
                V v = this.graph.getEdgeTarget(edge);
                double weight = this.graph.getEdgeWeight(edge);
                if (!this.weights.containsKey(u) || this.weights.get(u) < weight) {
                    this.weights.put((Double)u, weight);
                }
                if (this.weights.containsKey(v) && !(this.weights.get(v) < weight)) continue;
                this.weights.put((Double)v, weight);
            }
            if (!this.weights.keySet().equals(this.graph.vertexSet())) {
                throw new IllegalArgumentException("Graph must not have zero-degree nodes");
            }
        }

        protected void buildArcs() {
            for (E edge : this.graph.edgeSet()) {
                V u = this.graph.getEdgeSource(edge);
                V v = this.graph.getEdgeTarget(edge);
                double weight = this.graph.getEdgeWeight(edge);
                if (weight == this.weights.get(u)) {
                    Graphs.addEdgeWithVertices(this.digraph, v, u);
                }
                if (weight != this.weights.get(v)) continue;
                Graphs.addEdgeWithVertices(this.digraph, u, v);
            }
        }

        protected Map<V, Set<V>> extractClusters() {
            HashSet<V> leaves = new HashSet<V>(this.graph.vertexSet().size());
            HashMap clusters = new HashMap();
            for (V u : this.digraph.vertexSet()) {
                if (leaves.contains(u)) continue;
                HashSet<V> cluster = new HashSet<V>();
                cluster.add(u);
                ArrayDeque<V> queue = new ArrayDeque<V>(Graphs.successorListOf(this.digraph, u));
                HashSet<V> visited = new HashSet<V>();
                while (!queue.isEmpty()) {
                    V v = queue.remove();
                    leaves.add(v);
                    if (visited.contains(v)) continue;
                    clusters.remove(v);
                    if (this.digraph.containsVertex(v)) {
                        queue.addAll(Graphs.successorListOf(this.digraph, v));
                    }
                    cluster.add(v);
                    visited.add(v);
                }
                clusters.put(u, cluster);
            }
            return clusters;
        }
    }

    public static class Builder<V, E>
    implements ClusteringAlgorithmBuilder<V, E, MaxMax<V, E>> {
        @Override
        public MaxMax<V, E> apply(Graph<V, E> graph) {
            return new MaxMax<V, E>(graph);
        }
    }
}

