/*
 * Copyright 2020 Dmitry Ustalov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.nlpub.watset.graph;

import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.graph.DefaultEdge;

import java.util.List;
import java.util.Set;

/**
 * A MaxMax clustering.
 *
 * @param <V> the type of nodes in the graph
 */
@SuppressWarnings("unused")
public interface MaxMaxClustering<V> extends ClusteringAlgorithm.Clustering<V> {
    /**
     * Return the directed graph representation of the input graph.
     *
     * @return a directed graph
     */
    Graph<V, DefaultEdge> getDigraph();

    /**
     * Return the set of root nodes.
     *
     * @return a set of root nodes
     */
    Set<V> getRoots();

    /**
     * Default implementation of the MaxMax clustering.
     *
     * @param <V> the type of nodes in the graph
     */
    class MaxMaxClusteringImpl<V> extends ClusteringAlgorithm.ClusteringImpl<V> implements MaxMaxClustering<V> {
        /**
         * The directed graph.
         */
        private final Graph<V, DefaultEdge> digraph;

        /**
         * The map of root and non-root nodes.
         */
        private final Set<V> roots;

        /**
         * Construct a new MaxMax clustering.
         *
         * @param clusters the clusters
         * @param digraph  the directed graph representation
         * @param roots    the map of root and non-root nodes
         */
        public MaxMaxClusteringImpl(List<Set<V>> clusters, Graph<V, DefaultEdge> digraph, Set<V> roots) {
            super(clusters);
            this.digraph = digraph;
            this.roots = roots;
        }

        @Override
        public Graph<V, DefaultEdge> getDigraph() {
            return digraph;
        }

        @Override
        public Set<V> getRoots() {
            return roots;
        }
    }
}
