/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.JCommander;
import java.util.List;
import java.util.Objects;
import org.nlpub.watset.cli.ChineseWhispersCommand;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.cli.EmbeddingCommand;
import org.nlpub.watset.cli.GraphCommand;
import org.nlpub.watset.cli.MarkovClusteringCommand;
import org.nlpub.watset.cli.MarkovClusteringExternalCommand;
import org.nlpub.watset.cli.PairwiseCommand;
import org.nlpub.watset.cli.ProvidedClusteringCommand;
import org.nlpub.watset.cli.ProvidedClusteringFixedKCommand;
import org.nlpub.watset.cli.PurityCommand;
import org.nlpub.watset.cli.SenseEmbeddingCommand;
import org.nlpub.watset.cli.SensesCommand;
import org.nlpub.watset.cli.SpectralClusteringCommand;
import org.nlpub.watset.cli.VersionCommand;
import org.nlpub.watset.cli.WatsetCommand;

public final class Application
implements Runnable {
    private final JCommander jc;
    private ParseStatus status = ParseStatus.EMPTY;

    public static void main(String[] args) {
        Application app = new Application();
        switch (app.parse(args)) {
            case COMMAND: 
            case EMPTY_BUT_VERSION: {
                app.run();
                break;
            }
            default: {
                app.jc.usage();
                System.exit(1);
            }
        }
    }

    public Application() {
        Command.MainParameters parameters = new Command.MainParameters();
        this.jc = JCommander.newBuilder().addObject(parameters).addCommand("empty", new ProvidedClusteringCommand(parameters, "empty"), new String[0]).addCommand("singleton", new ProvidedClusteringCommand(parameters, "singleton"), new String[0]).addCommand("together", new ProvidedClusteringCommand(parameters, "together"), new String[0]).addCommand("components", new ProvidedClusteringCommand(parameters, "components"), new String[0]).addCommand("gn", new ProvidedClusteringFixedKCommand(parameters, "gn"), new String[0]).addCommand("kst", new ProvidedClusteringFixedKCommand(parameters, "kst"), new String[0]).addCommand("spectral", new SpectralClusteringCommand(parameters), new String[0]).addCommand("cw", new ChineseWhispersCommand(parameters), new String[0]).addCommand("mcl", new MarkovClusteringCommand(parameters), new String[0]).addCommand("mcl-bin", new MarkovClusteringExternalCommand(parameters), new String[0]).addCommand("embed", new EmbeddingCommand(parameters), new String[0]).addCommand("senses", new SensesCommand(parameters), new String[0]).addCommand("graph", new GraphCommand(parameters), new String[0]).addCommand("embedsenses", new SenseEmbeddingCommand(parameters), new String[0]).addCommand("watset", new WatsetCommand(parameters), new String[0]).addCommand("maxmax", new ProvidedClusteringCommand(parameters, "maxmax"), new String[0]).addCommand("pairwise", new PairwiseCommand(parameters), new String[0]).addCommand("purity", new PurityCommand(parameters), new String[0]).addCommand("version", new VersionCommand(parameters), new String[0]).build();
    }

    public ParseStatus parse(String ... args) {
        this.status = ParseStatus.EMPTY;
        this.jc.parse(args);
        Command.MainParameters parameters = (Command.MainParameters)this.jc.getObjects().get(0);
        if (Objects.nonNull(this.jc.getParsedCommand())) {
            this.status = ParseStatus.COMMAND;
        } else if (parameters.version) {
            this.status = ParseStatus.EMPTY_BUT_VERSION;
        }
        return this.status;
    }

    @Override
    public void run() {
        String command = this.status == ParseStatus.EMPTY_BUT_VERSION ? "version" : Objects.requireNonNull(this.jc.getParsedCommand(), "command should not be null");
        this.run(command);
    }

    public void run(String command) {
        List<Object> objects = this.jc.getCommands().get(command).getObjects();
        Command runnable = (Command)objects.get(0);
        runnable.run();
    }

    public static enum ParseStatus {
        COMMAND,
        EMPTY,
        EMPTY_BUT_VERSION;

    }
}

