/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.RandomConverter;
import org.nlpub.watset.util.ABCFormat;

abstract class Command
implements Runnable {
    private static final System.Logger logger = System.getLogger(Command.class.getSimpleName());
    public final MainParameters parameters;

    protected Command(MainParameters parameters) {
        this.parameters = Objects.requireNonNull(parameters, "parameters are not initialized");
    }

    public Stream<String> newInputStream() throws IOException {
        Objects.requireNonNull(this.parameters, "parameters are not initialized");
        return this.newInputStream(this.parameters.input);
    }

    public Stream<String> newInputStream(Path input) throws IOException {
        if (Objects.isNull(input)) {
            logger.log(System.Logger.Level.INFO, "Reading from standard input.");
            return new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8)).lines();
        }
        logger.log(System.Logger.Level.INFO, "Reading from {0}.", input);
        return Files.lines(input);
    }

    public BufferedWriter newOutputWriter() throws IOException {
        Objects.requireNonNull(this.parameters, "parameters are not initialized");
        if (Objects.isNull(this.parameters.output)) {
            logger.log(System.Logger.Level.INFO, "Writing to standard output.");
            return new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        }
        logger.log(System.Logger.Level.INFO, "Writing to {0}.", this.parameters.output);
        return Files.newBufferedWriter(this.parameters.output, new OpenOption[0]);
    }

    public Graph<String, DefaultWeightedEdge> getGraph() {
        Graph<String, DefaultWeightedEdge> graph;
        block8: {
            Stream<String> stream = this.newInputStream();
            try {
                Graph<String, DefaultWeightedEdge> graph2 = ABCFormat.parse(stream);
                logger.log(System.Logger.Level.INFO, "Read {0} nodes and {1} edges.", graph2.vertexSet().size(), graph2.edgeSet().size());
                graph = graph2;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return graph;
    }

    public static final class GlobalParameters {
        @Parameter(required=true, description="Global clustering algorithm", names={"-g", "--global"})
        public String algorithm;
        @DynamicParameter(description="Global clustering algorithm parameters", names={"-gp", "--global-params"})
        public Map<String, String> params = new HashMap<String, String>();
    }

    public static final class LocalParameters {
        @Parameter(required=true, description="Local clustering algorithm", names={"-l", "--local"})
        public String algorithm;
        @DynamicParameter(description="Local clustering algorithm parameters", names={"-lp", "--local-params"})
        public Map<String, String> params = new HashMap<String, String>();
    }

    public static final class FixedClustersParameters {
        @Parameter(required=true, description="Desired number of clusters", names={"-k"})
        public Integer k;
    }

    public static final class MainParameters {
        @Parameter(names={"-i", "--input"}, description="Input file")
        public Path input;
        @Parameter(names={"-o", "--output"}, description="Output file")
        public Path output;
        @Parameter(names={"-s", "--seed"}, description="Random seed", converter=RandomConverter.class)
        public JDKRandomGenerator random = new JDKRandomGenerator();
        @Parameter(names={"-v", "--version"}, description="Print version information")
        public boolean version;
    }
}

