/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameters;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.cli.EvaluateCommand;
import org.nlpub.watset.eval.Pairwise;
import org.nlpub.watset.eval.PrecisionRecall;

@Parameters(commandDescription="Pairwise Cluster Evaluation")
class PairwiseCommand
extends EvaluateCommand {
    public PairwiseCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public void run() {
        List<Set<String>> clusters = this.getClusters().getClusters();
        List<Set<String>> classes = this.getClasses().getClusters();
        Pairwise pairwise = new Pairwise();
        Set clusterPairs = Pairwise.transform((Collection)Objects.requireNonNull(clusters));
        Set classPairs = Pairwise.transform((Collection)Objects.requireNonNull(classes));
        PrecisionRecall results = pairwise.evaluate(clusterPairs, classPairs);
        try (BufferedWriter writer = this.newOutputWriter();){
            writer.write(String.format(Locale.ROOT, "Clusters: %d", clusters.size()));
            writer.write(System.lineSeparator());
            writer.write(String.format(Locale.ROOT, "Cluster Pairs: %d", clusterPairs.size()));
            writer.write(System.lineSeparator());
            writer.write(String.format(Locale.ROOT, "Classes: %d", classes.size()));
            writer.write(System.lineSeparator());
            writer.write(String.format(Locale.ROOT, "Class Pairs: %d", classPairs.size()));
            writer.write(System.lineSeparator());
            writer.write(String.format(Locale.ROOT, "Precision: %f", results.getPrecision()));
            writer.write(System.lineSeparator());
            writer.write(String.format(Locale.ROOT, "Recall: %f", results.getRecall()));
            writer.write(System.lineSeparator());
            writer.write(String.format(Locale.ROOT, "F1: %f", results.getF1Score()));
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

