/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.eval;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.alg.util.Pair;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;

public class Measurer<V, E> {
    private static final System.Logger logger = System.getLogger(Measurer.class.getSimpleName());
    public static final int REPETITIONS = 10;
    public static final int WARMUP = 5;
    private final ClusteringAlgorithmBuilder<V, E, ?> provider;
    private final int repetitions;
    private final int warmup;
    private final Graph<V, E> graph;
    private long[] durations;
    private int[] clusters;

    public Measurer(ClusteringAlgorithmBuilder<V, E, ?> provider, Graph<V, E> graph, int repetitions, int warmup) {
        this.provider = provider;
        this.repetitions = repetitions;
        this.warmup = warmup;
        this.graph = graph;
    }

    public Measurer(ClusteringAlgorithmBuilder<V, E, ?> provider, Graph<V, E> graph) {
        this(provider, graph, 10, 5);
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public List<Long> getDurations() {
        return Arrays.stream(this.durations).boxed().collect(Collectors.toList());
    }

    public List<Integer> getClusters() {
        return Arrays.stream(this.clusters).boxed().collect(Collectors.toList());
    }

    public void run() {
        System.gc();
        logger.log(System.Logger.Level.INFO, "Evaluating a graph with {0} node(s).", this.graph.vertexSet().size());
        this.durations = new long[this.repetitions];
        this.clusters = new int[this.repetitions];
        for (int i = -this.warmup; i < this.repetitions; ++i) {
            ClusteringAlgorithm algorithm = (ClusteringAlgorithm)this.provider.apply(this.graph);
            Measurement<V> result = this.measure(algorithm);
            if (i < 0) continue;
            this.durations[i] = ((Duration)result.getFirst()).toMillis();
            this.clusters[i] = ((ClusteringAlgorithm.Clustering)result.getSecond()).getNumberClusters();
        }
        logger.log(System.Logger.Level.INFO, "Evaluation complete.");
    }

    private Measurement<V> measure(ClusteringAlgorithm<V> algorithm) {
        Instant start = Instant.now();
        ClusteringAlgorithm.Clustering<V> clustering = algorithm.getClustering();
        Instant end = Instant.now();
        return new Measurement<V>(Duration.between(start, end), clustering);
    }

    public static class Measurement<V>
    extends Pair<Duration, ClusteringAlgorithm.Clustering<V>> {
        public Measurement(Duration duration, ClusteringAlgorithm.Clustering<V> clustering) {
            super(duration, clustering);
        }
    }
}

