/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;
import org.nlpub.watset.util.Neighbors;

public class SenseInduction<V, E> {
    protected final Graph<V, E> graph;
    protected final ClusteringAlgorithmBuilder<V, E, ?> local;

    public SenseInduction(Graph<V, E> graph, ClusteringAlgorithmBuilder<V, E, ?> local) {
        this.graph = GraphTests.requireUndirected(graph);
        this.local = Objects.requireNonNull(local);
    }

    public ClusteringAlgorithm.Clustering<V> clustering(V target) {
        Graph<V, E> ego = Neighbors.graph(this.graph, Objects.requireNonNull(target));
        ClusteringAlgorithm clustering = (ClusteringAlgorithm)this.local.apply(ego);
        return clustering.getClustering();
    }

    public List<Map<V, Number>> contexts(V target) {
        ClusteringAlgorithm.Clustering<V> clustering = this.clustering(target);
        ArrayList<Map<V, Number>> senses = new ArrayList<Map<V, Number>>(clustering.getNumberClusters());
        for (Set<V> cluster : clustering.getClusters()) {
            HashMap<V, Double> context = new HashMap<V, Double>(cluster.size());
            for (V neighbor : cluster) {
                context.put(neighbor, this.graph.getEdgeWeight(this.graph.getEdge(target, neighbor)));
            }
            senses.add(context);
        }
        return senses;
    }
}

