/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;

public class SingletonClustering<V, E>
implements ClusteringAlgorithm<V> {
    protected final Graph<V, E> graph;

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    public SingletonClustering(Graph<V, E> graph) {
        this.graph = GraphTests.requireUndirected(graph);
    }

    @Override
    public ClusteringAlgorithm.Clustering<V> getClustering() {
        List clusters = this.graph.vertexSet().stream().map(Collections::singleton).collect(Collectors.toList());
        return new ClusteringAlgorithm.ClusteringImpl(Collections.unmodifiableList(clusters));
    }

    public static class Builder<V, E>
    implements ClusteringAlgorithmBuilder<V, E, SingletonClustering<V, E>> {
        @Override
        public SingletonClustering<V, E> apply(Graph<V, E> graph) {
            return new SingletonClustering<V, E>(graph);
        }
    }
}

