/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.util.Sense;

public interface WatsetClustering<V>
extends ClusteringAlgorithm.Clustering<V> {
    public Graph<Sense<V>, DefaultWeightedEdge> getSenseGraph();

    public Map<Sense<V>, Map<Sense<V>, Number>> getContexts();

    public static class WatsetClusteringImpl<V>
    extends ClusteringAlgorithm.ClusteringImpl<V>
    implements WatsetClustering<V> {
        private final Map<V, Map<V, Integer>> inventory;
        private final Graph<Sense<V>, DefaultWeightedEdge> senseGraph;
        private Map<Sense<V>, Map<Sense<V>, Number>> contexts;

        public WatsetClusteringImpl(List<Set<V>> clusters, Map<V, Map<V, Integer>> inventory, Graph<Sense<V>, DefaultWeightedEdge> senseGraph) {
            super(clusters);
            this.inventory = inventory;
            this.senseGraph = senseGraph;
        }

        public Map<V, Map<V, Integer>> getInventory() {
            return this.inventory;
        }

        @Override
        public Graph<Sense<V>, DefaultWeightedEdge> getSenseGraph() {
            return this.senseGraph;
        }

        @Override
        public Map<Sense<V>, Map<Sense<V>, Number>> getContexts() {
            if (Objects.isNull(this.contexts)) {
                this.contexts = new HashMap<Sense<V>, Map<Sense<V>, Number>>(this.senseGraph.vertexSet().size());
                for (DefaultWeightedEdge edge : this.senseGraph.edgeSet()) {
                    Sense<V> source = this.senseGraph.getEdgeSource(edge);
                    Sense<V> target = this.senseGraph.getEdgeTarget(edge);
                    double weight = this.senseGraph.getEdgeWeight(edge);
                    if (!this.contexts.containsKey(source)) {
                        this.contexts.put(source, new HashMap());
                    }
                    if (!this.contexts.containsKey(target)) {
                        this.contexts.put(target, new HashMap());
                    }
                    this.contexts.get(source).put(target, weight);
                    this.contexts.get(target).put(source, weight);
                }
                if (this.contexts.size() != this.senseGraph.vertexSet().size()) {
                    throw new IllegalStateException("Mismatch in number of senses: expected " + this.senseGraph.vertexSet().size() + ", but got " + this.contexts.size());
                }
            }
            return Collections.unmodifiableMap(this.contexts);
        }
    }
}

