/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.clustering.MultiKMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.jgrapht.Graph;
import org.jgrapht.alg.clustering.GirvanNewmanClustering;
import org.jgrapht.alg.clustering.KSpanningTreeClustering;
import org.jgrapht.alg.interfaces.ClusteringAlgorithm;
import org.nlpub.watset.graph.ChineseWhispers;
import org.nlpub.watset.graph.ClusteringAlgorithmBuilder;
import org.nlpub.watset.graph.ComponentsClustering;
import org.nlpub.watset.graph.EmptyClustering;
import org.nlpub.watset.graph.MarkovClustering;
import org.nlpub.watset.graph.MarkovClusteringExternal;
import org.nlpub.watset.graph.MaxMax;
import org.nlpub.watset.graph.NodeWeighting;
import org.nlpub.watset.graph.NodeWeightings;
import org.nlpub.watset.graph.SingletonClustering;
import org.nlpub.watset.graph.SpectralClustering;
import org.nlpub.watset.graph.TogetherClustering;

public class ClusteringAlgorithmProvider<V, E>
implements ClusteringAlgorithmBuilder<V, E, ClusteringAlgorithm<V>> {
    private final ProvidingAlgorithm algorithm;
    private final Map<String, String> params;
    private final NodeWeighting<V, E> weighting;
    private final JDKRandomGenerator random;

    public ClusteringAlgorithmProvider(String algorithm, Map<String, String> params, JDKRandomGenerator random) {
        this.algorithm = ProvidingAlgorithm.valueOf(this.normalize(Objects.requireNonNull(algorithm, "algorithm is not specified")));
        this.params = Objects.requireNonNullElse(params, Collections.emptyMap());
        this.weighting = NodeWeightings.parse(params.get("mode"));
        this.random = Objects.requireNonNullElse(random, new JDKRandomGenerator());
    }

    @Override
    public ClusteringAlgorithm<V> apply(Graph<V, E> graph) {
        switch (this.algorithm) {
            case EMPTY: {
                return EmptyClustering.builder().apply(graph);
            }
            case TOGETHER: {
                return TogetherClustering.builder().apply(graph);
            }
            case SINGLETON: {
                return SingletonClustering.builder().apply(graph);
            }
            case COMPONENTS: {
                return ComponentsClustering.builder().apply(graph);
            }
            case K_SPANNING_TREE: {
                int kst = Integer.parseInt(Objects.requireNonNull(this.params.get("k"), "k must be specified"));
                return new KSpanningTreeClustering<V, E>(graph, kst);
            }
            case GIRVAN_NEWMAN: {
                int kgn = Integer.parseInt(Objects.requireNonNull(this.params.get("k"), "k must be specified"));
                return new GirvanNewmanClustering<V, E>(graph, kgn);
            }
            case SPECTRAL: {
                int kSpectral = Integer.parseInt(Objects.requireNonNull(this.params.get("k"), "k must be specified"));
                KMeansPlusPlusClusterer clusterer = new KMeansPlusPlusClusterer(kSpectral, -1, new EuclideanDistance(), this.random);
                int numTrials = this.params.containsKey("n") ? Integer.parseInt(this.params.get("n")) : 10;
                MultiKMeansPlusPlusClusterer metaClusterer = new MultiKMeansPlusPlusClusterer(clusterer, numTrials);
                return SpectralClustering.builder().setClusterer(metaClusterer).setK(kSpectral).apply(graph);
            }
            case CHINESE_WHISPERS: {
                return ChineseWhispers.builder().setWeighting(this.weighting).setRandom(this.random).apply(graph);
            }
            case MARKOV_CLUSTERING: {
                MarkovClustering.Builder<V, E> mcl = MarkovClustering.builder();
                if (this.params.containsKey("e")) {
                    mcl.setE(Integer.parseInt(this.params.get("e")));
                }
                if (this.params.containsKey("r")) {
                    mcl.setR(Double.parseDouble(this.params.get("r")));
                }
                return mcl.apply(graph);
            }
            case MARKOV_CLUSTERING_EXTERNAL: {
                MarkovClusteringExternal.Builder<V, E> mclOfficial = MarkovClusteringExternal.builder().setPath(Path.of(this.params.get("bin"), new String[0])).setThreads(Runtime.getRuntime().availableProcessors());
                if (this.params.containsKey("r")) {
                    mclOfficial.setR(Double.parseDouble(this.params.get("r")));
                }
                return mclOfficial.apply(graph);
            }
            case MAXMAX: {
                return MaxMax.builder().apply(graph);
            }
        }
        throw new IllegalArgumentException("Unknown algorithm: " + this.algorithm);
    }

    protected String normalize(String algorithm) {
        return algorithm.toUpperCase(Locale.ROOT).replaceAll("-", "_").replaceAll("GN", ProvidingAlgorithm.GIRVAN_NEWMAN.name()).replaceAll("KST", ProvidingAlgorithm.K_SPANNING_TREE.name()).replaceAll("CW", ProvidingAlgorithm.CHINESE_WHISPERS.name()).replaceAll("MCL_BIN", ProvidingAlgorithm.MARKOV_CLUSTERING_EXTERNAL.name()).replaceAll("MCL", ProvidingAlgorithm.CHINESE_WHISPERS.name());
    }

    public static enum ProvidingAlgorithm {
        EMPTY,
        TOGETHER,
        SINGLETON,
        COMPONENTS,
        K_SPANNING_TREE,
        GIRVAN_NEWMAN,
        SPECTRAL,
        CHINESE_WHISPERS,
        MARKOV_CLUSTERING,
        MARKOV_CLUSTERING_EXTERNAL,
        MAXMAX;

    }
}

