/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.jgrapht.Graph;
import org.jgrapht.util.VertexToIntegerMapping;
import org.nlpub.watset.graph.NodeEmbedding;

public final class Matrices {
    private static final System.Logger logger = System.getLogger(Matrices.class.getSimpleName());

    private Matrices() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static <V, E> RealMatrix buildAdjacencyMatrix(Graph<V, E> graph, VertexToIntegerMapping<V> mapping, boolean addLoops) {
        if (graph.vertexSet().size() > 2048) {
            logger.log(System.Logger.Level.WARNING, "Graph is large: %d nodes.", graph.vertexSet().size());
        }
        RealMatrix matrix = addLoops ? MatrixUtils.createRealIdentityMatrix(graph.vertexSet().size()) : MatrixUtils.createRealMatrix(graph.vertexSet().size(), graph.vertexSet().size());
        for (E edge : graph.edgeSet()) {
            int j;
            int i = mapping.getVertexMap().get(graph.getEdgeSource(edge));
            if (i == (j = mapping.getVertexMap().get(graph.getEdgeTarget(edge)).intValue())) continue;
            double weight = graph.getEdgeWeight(edge);
            matrix.setEntry(i, j, weight);
            matrix.setEntry(j, i, weight);
        }
        return matrix;
    }

    public static <V, E> RealMatrix buildDegreeMatrix(Graph<V, E> graph, VertexToIntegerMapping<V> mapping) {
        double[] data = new double[graph.vertexSet().size()];
        for (Map.Entry<V, Integer> entry : mapping.getVertexMap().entrySet()) {
            data[entry.getValue().intValue()] = graph.degreeOf(entry.getKey());
        }
        return MatrixUtils.createRealDiagonalMatrix(data);
    }

    public static RealMatrix buildSymmetricLaplacian(RealMatrix degree, RealMatrix adjacency) {
        RealMatrix sqrt = degree.copy();
        sqrt.walkInOptimizedOrder(new InflateVisitor(0.5));
        RealMatrix isqrt = MatrixUtils.inverse(sqrt);
        RealMatrix laplacian = degree.subtract(adjacency);
        return isqrt.multiply(laplacian).multiply(isqrt);
    }

    public static RealVector computeRowNorms(RealMatrix matrix) {
        ArrayRealVector vector = new ArrayRealVector(matrix.getRowDimension());
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            vector.setEntry(i, matrix.getRowVector(i).getNorm());
        }
        return vector;
    }

    public static <V> List<NodeEmbedding<V>> computeSpectralEmbedding(RealMatrix laplacian, VertexToIntegerMapping<V> mapping, int k) {
        EigenDecomposition eigen = new EigenDecomposition(laplacian);
        RealMatrix matrix = eigen.getV().getSubMatrix(0, laplacian.getRowDimension() - 1, 0, k - 1);
        RealVector norms = Matrices.computeRowNorms(matrix);
        matrix.walkInOptimizedOrder(new RowNormalizeVisitor(norms));
        return mapping.getVertexMap().entrySet().stream().map(e -> new NodeEmbedding(e.getKey(), matrix.getRow((Integer)e.getValue()))).collect(Collectors.toList());
    }

    public static <V> List<NodeEmbedding<V>> computeSpectralEmbedding(Graph<V, ?> graph, VertexToIntegerMapping<V> mapping, int k) {
        RealMatrix degree = Matrices.buildDegreeMatrix(graph, mapping);
        RealMatrix adjacency = Matrices.buildAdjacencyMatrix(graph, mapping, false);
        RealMatrix laplacian = Matrices.buildSymmetricLaplacian(degree, adjacency);
        return Matrices.computeSpectralEmbedding(laplacian, mapping, k);
    }

    public static class RowNormalizeVisitor
    extends DefaultRealMatrixChangingVisitor {
        private final RealVector norms;

        public RowNormalizeVisitor(RealVector norms) {
            this.norms = norms;
        }

        @Override
        public double visit(int row, int column, double value) {
            return value / this.norms.getEntry(row);
        }
    }

    public static class ColumnNormalizeVisitor
    extends DefaultRealMatrixChangingVisitor {
        private final RealVector sums;

        public ColumnNormalizeVisitor(RealVector sums) {
            this.sums = sums;
        }

        @Override
        public double visit(int row, int column, double value) {
            return value / this.sums.getEntry(column);
        }
    }

    public static class ColumnSumVisitor
    extends DefaultRealMatrixPreservingVisitor {
        private final RealVector sums;

        public ColumnSumVisitor(RealVector sums) {
            this.sums = sums;
        }

        @Override
        public void visit(int row, int column, double value) {
            this.sums.addToEntry(column, value);
        }
    }

    public static class InflateVisitor
    extends DefaultRealMatrixChangingVisitor {
        private final double r;

        public InflateVisitor(double r) {
            this.r = r;
        }

        @Override
        public double visit(int row, int column, double value) {
            return StrictMath.pow(value, this.r);
        }
    }
}

