/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.nlpub.watset.graph.NodeEmbedding;

public final class Word2VecFormat {
    public static final Pattern SPACES = Pattern.compile(" ");

    private Word2VecFormat() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static <V> void write(BufferedWriter writer, List<NodeEmbedding<V>> embeddings, SpaceStrategy spaceStrategy) throws IOException {
        if (embeddings.isEmpty()) {
            throw new IllegalArgumentException("embeddings should not be empty");
        }
        DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ROOT));
        df.setMaximumFractionDigits(10);
        int k = embeddings.get(0).getPoint().length;
        writer.write(Integer.toString(embeddings.size()));
        writer.write(32);
        writer.write(Integer.toString(k));
        writer.write(10);
        for (NodeEmbedding<V> node : embeddings) {
            String label = node.get().toString();
            if (label.contains(" ")) {
                switch (spaceStrategy) {
                    case FAIL: {
                        throw new IllegalStateException("node has spaces: " + label);
                    }
                    case REPLACE: {
                        label = SPACES.matcher(label).replaceAll("_");
                        break;
                    }
                }
            }
            writer.write(label);
            for (double v : node.getPoint()) {
                writer.write(32);
                writer.write(df.format(v));
            }
            writer.write(10);
        }
    }

    public static enum SpaceStrategy {
        IGNORE,
        FAIL,
        REPLACE;

    }
}

