/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands;

import highfive.commands.DataSourceCommand;
import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.model.Column;
import highfive.model.Identifier;
import highfive.model.Table;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class ListColumnsAndCheckCommand
extends DataSourceCommand {
    public ListColumnsAndCheckCommand(String datasourceName) throws InvalidConfigurationException, SQLException, UnsupportedDatabaseTypeException {
        super("List Columns", datasourceName);
    }

    @Override
    public void execute() throws SQLException, UnsupportedDatabaseTypeException, InvalidSchemaException, InvalidConfigurationException {
        List<Identifier> tableNames = this.ds.getDialect().listTablesNames();
        this.info(" ");
        this.info("Tables (" + tableNames.size() + "):");
        TreeMap<String, Integer> typeCount = new TreeMap<String, Integer>();
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Identifier tn : tableNames) {
            Table t = this.ds.getDialect().getTableMetaData(tn);
            tables.add(t);
            this.info(" ");
            this.info("Table " + tn.getGenericName() + " (" + t.getColumns().size() + " columns):");
            for (Column c : t.getColumns()) {
                String key = c.getRenderedType() + " [" + (c.getSerializer() == null ? "N/A" : c.getSerializer().getName()) + "]";
                this.info("  " + c.getName() + ": " + key);
                Integer count = (Integer)typeCount.get(key);
                count = count == null ? Integer.valueOf(1) : count + 1;
                typeCount.put(key, count);
            }
        }
        this.info(" ");
        this.info("Summary of types found (" + typeCount.size() + "):");
        for (String t : typeCount.keySet()) {
            this.info("  " + t + ": " + typeCount.get(t));
        }
        this.info(" ");
        this.info("Row Count:");
        for (Identifier tn : tableNames) {
            String tid = this.ds.getDialect().renderSQLTableIdentifier(tn);
            String sql = "select count(*) from " + tid;
            PreparedStatement ps = this.ds.getConnection().prepareStatement(sql);
            try {
                ResultSet rs = ps.executeQuery();
                try {
                    if (!rs.next()) continue;
                    long count = rs.getLong(1);
                    this.info("  " + tn.getGenericName() + ": " + count + " rows");
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            finally {
                if (ps == null) continue;
                ps.close();
            }
        }
        this.checkIfHashingAndCopyingIsSupported(tables);
    }
}

