/*
 * Decompiled with CFR 0.152.
 */
package highfive.dialects;

import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.exceptions.UnsupportedSQLFeatureException;
import highfive.model.Column;
import highfive.model.DataSource;
import highfive.model.Dialect;
import highfive.model.Identifier;
import highfive.model.Serializer;
import highfive.model.Table;
import highfive.serializers.BigDecimalSerializer;
import highfive.serializers.ByteArraySerializer;
import highfive.serializers.DoubleSerializer;
import highfive.serializers.IntegerSerializer;
import highfive.serializers.LocalDateSerializer;
import highfive.serializers.LocalDateTimeSerializer;
import highfive.serializers.LocalTimeSerializer;
import highfive.serializers.LongSerializer;
import highfive.serializers.OffsetDateTimeSerializer;
import highfive.serializers.StringSerializer;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SQLServerDialect
extends Dialect {
    public SQLServerDialect(DataSource ds, Connection conn) {
        super(ds, conn);
    }

    @Override
    public String getName() {
        return "SQL Server";
    }

    @Override
    public List<Identifier> listTablesNames() throws SQLException, InvalidSchemaException {
        ArrayList<Identifier> tables = new ArrayList<Identifier>();
        String sql = "select name from " + (this.ds.getCatalog() == null || this.ds.getCatalog().isEmpty() ? "" : this.escapeIdentifierAsNeeded(this.ds.getCatalog()) + ".") + "sys.tables where schema_name(schema_id) = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            ps.setString(1, this.ds.getSchema());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String table = rs.getString(1);
                    if (rs.wasNull()) {
                        throw new InvalidSchemaException("The schema includes a table with no name.");
                    }
                    if (!this.ds.getTableFilter().accepts(table)) continue;
                    tables.add(new Identifier(table, this.ds.getRemoveTablePrefix(), this));
                }
            }
        }
        return tables;
    }

    @Override
    public Table getTableMetaData(Identifier tn) throws SQLException, UnsupportedDatabaseTypeException {
        ArrayList<Column> columns = new ArrayList<Column>();
        String cat = this.ds.getCatalog() == null || this.ds.getCatalog().isEmpty() ? "" : "" + this.escapeIdentifierAsNeeded(this.ds.getCatalog()) + ".";
        String sql = "select c.name, t.name, c.max_length, c.precision, c.scale, ix.key_ordinal\nfrom " + cat + "sys.columns c\njoin " + cat + "sys.types t on c.user_type_id = t.user_type_id\nouter apply (\n  select ic.key_ordinal\n  from " + cat + "sys.index_columns ic\n  join " + cat + "sys.indexes i on ic.object_id = i.object_id and ic.index_id = i.index_id\n  where ic.object_id = c.object_id and ic.column_id = c.column_id and i.is_primary_key = 1\n) ix\nwhere c.object_id = object_id('" + cat + this.escapeIdentifierAsNeeded(this.ds.getSchema()) + "." + tn.renderSQL() + "')";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                Integer len;
                int col = 1;
                String name = this.readString(rs, col++);
                if (!this.ds.getColumnFilter().accepts(name)) continue;
                String type = this.readString(rs, col++);
                boolean unsigned = false;
                BigInteger length = (len = this.readInt(rs, col++)) == null ? null : BigInteger.valueOf(len.longValue());
                Integer precision = this.readInt(rs, col++);
                Integer scale = this.readInt(rs, col++);
                Integer pkPosition = this.readInt(rs, col++);
                String renderedType = this.renderType(name, type, length, precision, scale);
                Serializer<?> serializer = super.getSerializer(renderedType, tn, name, type, unsigned, length, precision, scale);
                Column c = new Column(name, type, length, precision, scale, renderedType, pkPosition, serializer);
                columns.add(c);
            }
        }
        return new Table(tn, columns);
    }

    private String renderType(String name, String type, BigInteger maxLength, Integer precision, Integer scale) {
        if ("varchar".equals(type) || "char".equals(type) || "nvarchar".equals(type) || "nchar".equals(type) || "text".equals(type) || "ntext".equals(type) || "sysname".equals(type)) {
            return type + "(" + maxLength + ")";
        }
        if ("decimal".equals(type) || "numeric".equals(type)) {
            return type + "(" + precision + ", " + scale + ")";
        }
        if ("money".equals(type) || "smallmoney".equals(type)) {
            return type;
        }
        if ("int".equals(type) || "bigint".equals(type) || "smallint".equals(type) || "tinyint".equals(type) || "bit".equals(type)) {
            return type;
        }
        if ("float".equals(type) || "real".equals(type)) {
            if (precision == null) {
                return type;
            }
            return type + "(" + precision + ")";
        }
        if ("date".equals(type) || "datetime".equals(type) || "smalldatetime".equals(type) || "datetime2".equals(type) || "datetimeoffset".equals(type) || "time".equals(type)) {
            return type;
        }
        if ("binary".equals(type) || "varbinary".equals(type)) {
            return type + "(" + maxLength + ")";
        }
        if ("hierarchyid".equals(type)) {
            return type;
        }
        if ("timestamp".equals(type)) {
            return type;
        }
        if ("uniqueidentifier".equals(type)) {
            return type;
        }
        if ("geometry".equals(type) || "geography".equals(type)) {
            return type;
        }
        if ("xml".equals(type)) {
            return type;
        }
        if ("image".equals(type)) {
            return type;
        }
        return type + "(" + maxLength + " | " + precision + ", " + scale + ")";
    }

    @Override
    protected Serializer<?> getDefaultSerializer(Identifier table, String name, String type, boolean unsigned, BigInteger maxLength, Integer precision, Integer scale) throws UnsupportedDatabaseTypeException {
        if ("varchar".equals(type) || "char".equals(type) || "nvarchar".equals(type) || "nchar".equals(type) || "text".equals(type) || "ntext".equals(type) || "sysname".equals(type)) {
            return new StringSerializer();
        }
        if ("decimal".equals(type) || "numeric".equals(type)) {
            return new BigDecimalSerializer();
        }
        if ("money".equals(type) || "smallmoney".equals(type)) {
            return new BigDecimalSerializer();
        }
        if ("int".equals(type) || "smallint".equals(type) || "tinyint".equals(type) || "bit".equals(type)) {
            return new IntegerSerializer();
        }
        if ("bigint".equals(type)) {
            return new LongSerializer();
        }
        if ("float".equals(type) || "real".equals(type)) {
            return new DoubleSerializer();
        }
        if ("date".equals(type)) {
            return new LocalDateSerializer();
        }
        if ("datetime".equals(type) || "smalldatetime".equals(type) || "datetime2".equals(type)) {
            return new LocalDateTimeSerializer();
        }
        if ("datetimeoffset".equals(type)) {
            return new OffsetDateTimeSerializer();
        }
        if ("time".equals(type)) {
            return new LocalTimeSerializer();
        }
        if ("binary".equals(type) || "varbinary".equals(type)) {
            return new ByteArraySerializer();
        }
        if ("hierarchyid".equals(type)) {
            return null;
        }
        if ("timestamp".equals(type)) {
            return null;
        }
        if ("image".equals(type)) {
            return new ByteArraySerializer();
        }
        if ("uniqueidentifier".equals(type)) {
            return new ByteArraySerializer();
        }
        if ("geometry".equals(type) || "geography".equals(type)) {
            return null;
        }
        if ("xml".equals(type)) {
            return new StringSerializer();
        }
        return null;
    }

    private String readString(ResultSet rs, int ordinal) throws SQLException {
        String v = rs.getString(ordinal);
        if (rs.wasNull()) {
            return null;
        }
        return v;
    }

    private Integer readInt(ResultSet rs, int ordinal) throws SQLException {
        Integer v = rs.getInt(ordinal);
        if (rs.wasNull()) {
            return null;
        }
        return v;
    }

    private <T> T readObject(ResultSet rs, int ordinal, Class<T> cls) throws SQLException {
        T v = rs.getObject(ordinal, cls);
        if (rs.wasNull()) {
            return null;
        }
        return v;
    }

    @Override
    public String escapeIdentifierAsNeeded(String canonicalName) {
        if (canonicalName.matches("^[A-Za-z0-9_]+$")) {
            return canonicalName;
        }
        return "\"" + canonicalName.replace("\"", "\"\"").replace("'", "''") + "\"";
    }

    @Override
    public String renderSQLTableIdentifier(Identifier table) {
        String catalog = this.ds.getCatalog();
        String schema = this.ds.getSchema();
        String cat = catalog == null || catalog.isEmpty() ? "" : this.escapeIdentifierAsNeeded(catalog) + ".";
        return cat + (schema == null ? "" : this.escapeIdentifierAsNeeded(schema) + ".") + table.renderSQL();
    }

    @Override
    public String renderHeadLimit(Long limit) {
        return limit == null ? "" : " top " + limit;
    }

    @Override
    public String renderTailLimit(Long limit) {
        return "";
    }

    @Override
    public Boolean getDefaultAutoCommit() {
        return true;
    }

    @Override
    public String renderNullsOrdering(boolean nullsFirst) throws UnsupportedSQLFeatureException {
        throw new UnsupportedSQLFeatureException("SQL Server does not implement NULLS FIRST or NULLS LAST in the ORDER BY clause.");
    }
}

