/*
 * Decompiled with CFR 0.152.
 */
package highfive.model;

import highfive.model.OptionalProperty;
import highfive.utils.SetUtl;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class TableFilter
implements OptionalProperty {
    private TreeSet<String> allowedTables;
    private Set<String> acceptedTables;

    public TableFilter(Set<String> allowedTables) {
        this.allowedTables = allowedTables == null || allowedTables.isEmpty() ? null : new TreeSet(allowedTables.stream().map(n -> n.toLowerCase()).collect(Collectors.toSet()));
        this.reset();
    }

    public void reset() {
        this.acceptedTables = new HashSet<String>();
    }

    public boolean allTablesFound() {
        return this.allowedTables == null || this.acceptedTables.size() >= this.allowedTables.size();
    }

    public int found() {
        return this.acceptedTables.size();
    }

    public boolean accepts(String canonicalName) {
        if (this.allowedTables == null) {
            return true;
        }
        if (canonicalName == null) {
            return false;
        }
        String genericName = canonicalName.toLowerCase();
        boolean accepted = this.allowedTables.contains(genericName);
        if (accepted) {
            this.acceptedTables.add(genericName);
        }
        return accepted;
    }

    @Override
    public boolean declared() {
        return this.allowedTables != null;
    }

    public int size() {
        return this.allowedTables == null ? 0 : this.allowedTables.size();
    }

    public Set<String> listNotAccepted() {
        if (this.allowedTables == null) {
            return new HashSet<String>();
        }
        return new TreeSet<String>(SetUtl.difference(this.allowedTables, this.acceptedTables));
    }

    public String render() {
        return this.allowedTables == null ? "" : this.allowedTables.stream().collect(Collectors.joining(","));
    }
}

