/*
 * Decompiled with CFR 0.152.
 */
package highfive;

import highfive.commands.Command;
import highfive.commands.CopyCommand;
import highfive.commands.HashCommand;
import highfive.commands.ListColumnsAndCheckCommand;
import highfive.commands.ListTablesAndCheckCommand;
import highfive.commands.VerifyCommand;
import highfive.exceptions.ApplicationException;
import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HighFive {
    private static final SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public static void main(String[] args) {
        try {
            HighFive.processCommand(args);
        }
        catch (Throwable e) {
            HighFive.error(e);
            System.exit(1);
        }
    }

    private static void processCommand(String[] args) {
        try {
            if (args.length == 2 && "listtables".equals(args[0])) {
                ListTablesAndCheckCommand c = new ListTablesAndCheckCommand(args[1]);
                try {
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error(e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 2 && "listcolumns".equals(args[0])) {
                ListColumnsAndCheckCommand c = new ListColumnsAndCheckCommand(args[1]);
                try {
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error(e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 2 && "hash".equals(args[0])) {
                try {
                    HashCommand c = new HashCommand(args[1]);
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error("Could not hash data: " + e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 3 && "verify".equals(args[0])) {
                try {
                    VerifyCommand c = new VerifyCommand(args[1], args[2]);
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error("Could not verify data: " + e.getMessage());
                    System.exit(1);
                }
            } else if (args.length == 3 && "copy".equals(args[0])) {
                try {
                    CopyCommand c = new CopyCommand(args[1], args[2]);
                    ((Command)c).run();
                    System.exit(0);
                }
                catch (ApplicationException e) {
                    HighFive.error("Could not copy data: " + e.getMessage());
                    System.exit(1);
                }
            } else {
                if (args.length == 0) {
                    HighFive.error("Must specify a command.");
                } else {
                    HighFive.error("Invalid command: " + args[0]);
                }
                HighFive.info("Usage: java -jar highfive.jar [ listtables <datasource> | listcolumns <datasource> | hash <datasource> | verify <datasource> <baseline-file> | copy <from-datasource> <to-datasource> ]");
                System.exit(1);
            }
        }
        catch (InvalidConfigurationException | UnsupportedDatabaseTypeException | IOException | NoSuchAlgorithmException | SQLException e) {
            HighFive.error(e);
            System.exit(1);
        }
        catch (RuntimeException e) {
            HighFive.error(e);
            System.exit(1);
        }
    }

    private static void info(String s) {
        System.out.println(DF.format(new Date()) + " INFO  - " + s);
    }

    private static void error(String s) {
        System.out.println(DF.format(new Date()) + " ERROR - " + s);
    }

    private static void error(Throwable e) {
        System.out.print(DF.format(new Date()) + " ERROR - ");
        e.printStackTrace(System.out);
    }
}

