/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands;

import highfive.commands.Command;
import highfive.exceptions.CouldNotCopyDataException;
import highfive.exceptions.CouldNotHashException;
import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.InvalidHashFileException;
import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.model.Column;
import highfive.model.DataSource;
import highfive.model.Table;
import highfive.model.TableFilter;
import highfive.model.TableHashingOrdering;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.List;

public abstract class DataSourceCommand
extends Command {
    protected DataSource ds;
    protected static final DecimalFormat DF = new DecimalFormat("#,##0");

    public DataSourceCommand(String commandName, String datasourceName) throws InvalidConfigurationException, SQLException, UnsupportedDatabaseTypeException {
        super(commandName);
        this.info("HighFive 1.2.0 - build 20240815-003824 - Command: " + super.getCommandName());
        this.info(" ");
        this.ds = DataSource.load(datasourceName);
    }

    @Override
    public void run() throws SQLException, UnsupportedDatabaseTypeException, InvalidSchemaException, NoSuchAlgorithmException, CouldNotHashException, IOException, InvalidHashFileException, CouldNotCopyDataException, InvalidConfigurationException {
        this.ds.show("DataSource");
        this.execute();
    }

    public abstract void execute() throws SQLException, UnsupportedDatabaseTypeException, InvalidSchemaException, NoSuchAlgorithmException, CouldNotHashException, IOException, InvalidHashFileException, CouldNotCopyDataException, InvalidConfigurationException;

    protected void displayRowCount(List<Table> tables) throws SQLException {
        this.info(" ");
        this.info("Row Count:");
        for (Table t : tables) {
            String tid = this.ds.getDialect().renderSQLTableIdentifier(t.getIdentifier());
            String sql = "select count(*) from " + tid;
            PreparedStatement ps = this.ds.getConnection().prepareStatement(sql);
            try {
                ResultSet rs = ps.executeQuery();
                try {
                    if (!rs.next()) continue;
                    long count = rs.getLong(1);
                    this.info("  " + t.getIdentifier().getGenericName() + ": " + DF.format(count) + " rows");
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            finally {
                if (ps == null) continue;
                ps.close();
            }
        }
    }

    protected void checkIfHashingAndCopyingIsSupported(List<Table> tables) throws SQLException, UnsupportedDatabaseTypeException, InvalidConfigurationException {
        boolean schemaCanBeCopied;
        this.info(" ");
        this.info("Hashing & copying preconditions:");
        int tablesSortable = 0;
        int tableCount = 0;
        int columnsSupported = 0;
        int columnCount = 0;
        for (String na : this.ds.getTableFilter().listNotAccepted()) {
            this.error("  - Table " + na + " not found.");
        }
        for (Table t : tables) {
            ++tableCount;
            boolean hasPK = false;
            for (Column c : t.getColumns()) {
                ++columnCount;
                if (c.getPKPosition() != null) {
                    hasPK = true;
                }
                if (c.getSerializer() != null) {
                    ++columnsSupported;
                    continue;
                }
                this.error("  - Unsupported data type of column " + t.getIdentifier().getCanonicalName() + "." + c.getCanonicalName() + ": " + c.getRenderedType());
            }
            TableHashingOrdering tho = this.ds.getHashingOrderings().get(t.getIdentifier().getGenericName());
            if (tho != null) {
                tho.validate(this.ds, t);
                ++tablesSortable;
                continue;
            }
            if (hasPK) {
                ++tablesSortable;
                continue;
            }
            this.error("  - Table " + t.getIdentifier().getCanonicalName() + " does not have a sorting order for hashing. Add a primary key or declare a unique criteria for ordering using the property '" + this.ds.getName() + ".hashing.ordering'.");
        }
        TableFilter tf = this.ds.getTableFilter();
        boolean allTablesFound = tf.allTablesFound();
        boolean allTablesSortable = tablesSortable >= tableCount;
        boolean allColumnsSupported = columnsSupported >= columnCount;
        boolean schemaCanBeHashed = allTablesFound && allTablesSortable && allColumnsSupported;
        boolean bl = schemaCanBeCopied = allTablesFound && allColumnsSupported;
        if (this.ds.getTableFilter().declared()) {
            this.info("  Tables found" + (tf.size() > 0 ? " (" + tf.found() + "/" + tf.size() + ")" : "") + " - " + (allTablesFound ? "PASS" : "FAIL"));
        }
        this.info("  Tables have primary key and/or have a declared hashing ordering (" + tablesSortable + "/" + tableCount + ") - " + (allTablesSortable ? "PASS" : "FAIL"));
        this.info("  Column types are supported (" + columnsSupported + "/" + columnCount + ") - " + (allColumnsSupported ? "PASS" : "FAIL"));
        if (schemaCanBeCopied) {
            this.info("  The schema is suitable for data copy.");
        } else {
            this.info("  The schema is not suitable data copy.");
        }
        if (schemaCanBeHashed) {
            this.info("  The schema data can be hashed.");
        } else {
            this.info("  The schema data cannot be hashed.");
        }
    }
}

