/*
 * Decompiled with CFR 0.152.
 */
package highfive.dialects;

import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.exceptions.UnsupportedSQLFeatureException;
import highfive.model.Column;
import highfive.model.DataSource;
import highfive.model.Dialect;
import highfive.model.Identifier;
import highfive.model.PKColumn;
import highfive.model.Serializer;
import highfive.model.Table;
import highfive.serializers.BigDecimalSerializer;
import highfive.serializers.BigIntegerSerializer;
import highfive.serializers.ByteArraySerializer;
import highfive.serializers.DoubleSerializer;
import highfive.serializers.IntegerSerializer;
import highfive.serializers.LocalDateSerializer;
import highfive.serializers.LocalDateTimeSerializer;
import highfive.serializers.LocalTimeSerializer;
import highfive.serializers.LongSerializer;
import highfive.serializers.OffsetDateTimeSerializer;
import highfive.serializers.StringSerializer;
import highfive.utils.Utl;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MySQLDialect
extends Dialect {
    public MySQLDialect(DataSource ds, Connection conn) {
        super(ds, conn);
    }

    @Override
    public String getName() {
        return "MySQL";
    }

    @Override
    public List<Identifier> listTablesNames() throws SQLException, InvalidSchemaException {
        ArrayList<Identifier> tables = new ArrayList<Identifier>();
        String sql = "select table_name from information_schema.tables where table_schema = ? and table_type = 'BASE TABLE'";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            String database = Utl.coalesce(this.ds.getCatalog(), this.ds.getSchema());
            ps.setString(1, database);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String table = rs.getString(1);
                    if (rs.wasNull()) {
                        throw new InvalidSchemaException("The schema includes a table with no name.");
                    }
                    if (!this.ds.getTableFilter().accepts(table)) continue;
                    tables.add(new Identifier(table, this.ds.getRemoveTablePrefix(), this));
                }
            }
        }
        return tables;
    }

    @Override
    public Table getTableMetaData(Identifier tn) throws SQLException, UnsupportedDatabaseTypeException {
        List<PKColumn> pkColumns = this.getPrimaryKeyColumns(this.conn, this.ds.getCatalog(), this.ds.getSchema(), tn);
        Map<String, Integer> pkByName = pkColumns.stream().collect(Collectors.toMap(x -> x.getCanonicalName(), x -> x.getPosition()));
        ArrayList<Column> columns = new ArrayList<Column>();
        String sql = "select column_name, data_type, character_maximum_length, numeric_precision, numeric_scale, column_type from information_schema.columns where table_schema = ? and table_name = ?";
        try (PreparedStatement ps = this.conn.prepareStatement(sql);){
            String database = Utl.coalesce(this.ds.getCatalog(), this.ds.getSchema());
            ps.setString(1, database);
            ps.setString(2, tn.getCanonicalName());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String columnType;
                    int col = 1;
                    String name = this.readString(rs, col++);
                    if (!this.ds.getColumnFilter().accepts(name)) continue;
                    String type = this.readString(rs, col++);
                    BigInteger maxLength = this.readObject(rs, col++, BigInteger.class);
                    Integer precision = this.readInt(rs, col++);
                    Integer scale = this.readInt(rs, col++);
                    boolean unsigned = (columnType = this.readString(rs, col++)) != null && columnType.contains("unsigned");
                    Integer pkPosition = pkByName.get(name);
                    String renderedType = this.renderType(name, type, unsigned, maxLength, precision, scale);
                    Serializer<?> serializer = super.getSerializer(renderedType, tn, name, type, unsigned, maxLength, precision, scale);
                    Column c = new Column(name, type, maxLength, precision, scale, renderedType, pkPosition, serializer);
                    columns.add(c);
                }
            }
        }
        return new Table(tn, columns);
    }

    private String renderType(String name, String type, boolean unsigned, BigInteger length, Integer precision, Integer scale) {
        if ("char".equals(type) || "varchar".equals(type)) {
            return type + "(" + length + ")";
        }
        if ("tinytext".equals(type) || "text".equals(type) || "mediumtext".equals(type) || "longtext".equals(type)) {
            return type;
        }
        if ("tinyint".equals(type) || "smallint".equals(type) || "mediumint".equals(type) || "int".equals(type) || "bigint".equals(type)) {
            return type + (unsigned ? " unsigned" : "");
        }
        if ("decimal".equals(type)) {
            return type + "(" + precision + ", " + scale + ")";
        }
        if ("float".equals(type) || "double".equals(type)) {
            return type + (unsigned ? " unsigned" : "");
        }
        if ("date".equals(type) || "datetime".equals(type) || "timestamp".equals(type) || "time".equals(type) || "year".equals(type)) {
            return type;
        }
        if ("tinyblob".equals(type) || "blob".equals(type) || "mediumblob".equals(type) || "longblob".equals(type)) {
            return type;
        }
        if ("enum".equals(type)) {
            return type;
        }
        if ("set".equals(type)) {
            return type;
        }
        return type;
    }

    @Override
    protected Serializer<?> getDefaultSerializer(Identifier table, String name, String type, boolean unsigned, BigInteger maxLength, Integer precision, Integer scale) throws UnsupportedDatabaseTypeException {
        if ("char".equals(type) || "varchar".equals(type)) {
            return new StringSerializer();
        }
        if ("tinytext".equals(type) || "text".equals(type) || "mediumtext".equals(type) || "longtext".equals(type)) {
            return new StringSerializer();
        }
        if ("tinyint".equals(type) || "smallint".equals(type) || "mediumint".equals(type) || "int".equals(type) && !unsigned) {
            return new IntegerSerializer();
        }
        if ("int".equals(type) && unsigned || "bigint".equals(type) && !unsigned) {
            return new LongSerializer();
        }
        if ("bigint".equals(type) && unsigned) {
            return new BigIntegerSerializer();
        }
        if ("decimal".equals(type)) {
            return new BigDecimalSerializer();
        }
        if ("float".equals(type) || "double".equals(type) && !unsigned) {
            return new DoubleSerializer();
        }
        if ("double".equals(type) && unsigned) {
            return new BigDecimalSerializer();
        }
        if ("date".equals(type)) {
            return new LocalDateSerializer();
        }
        if ("datetime".equals(type)) {
            return new LocalDateTimeSerializer();
        }
        if ("timestamp".equals(type)) {
            return new OffsetDateTimeSerializer();
        }
        if ("time".equals(type)) {
            return new LocalTimeSerializer();
        }
        if ("year".equals(type)) {
            return new IntegerSerializer();
        }
        if ("tinyblob".equals(type) || "blob".equals(type) || "mediumblob".equals(type) || "longblob".equals(type)) {
            return new ByteArraySerializer();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private List<PKColumn> getPrimaryKeyColumns(Connection conn, String catalog, String schema, Identifier table) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String readString(ResultSet rs, int ordinal) throws SQLException {
        String v = rs.getString(ordinal);
        if (rs.wasNull()) {
            return null;
        }
        return v;
    }

    private Integer readInt(ResultSet rs, int ordinal) throws SQLException {
        Integer v = rs.getInt(ordinal);
        if (rs.wasNull()) {
            return null;
        }
        return v;
    }

    private <T> T readObject(ResultSet rs, int ordinal, Class<T> cls) throws SQLException {
        T v = rs.getObject(ordinal, cls);
        if (rs.wasNull()) {
            return null;
        }
        return v;
    }

    @Override
    public String escapeIdentifierAsNeeded(String canonicalName) {
        return "`" + canonicalName + "`";
    }

    @Override
    public String renderSQLTableIdentifier(Identifier table) {
        String database = Utl.coalesce(this.ds.getCatalog(), this.ds.getSchema());
        return (database == null ? "" : this.escapeIdentifierAsNeeded(database) + ".") + table.renderSQL();
    }

    @Override
    public String renderHeadLimit(Long limit) {
        return "";
    }

    @Override
    public String renderTailLimit(Long limit) {
        return limit == null ? "" : " limit " + limit;
    }

    @Override
    public Boolean getDefaultAutoCommit() {
        return true;
    }

    @Override
    public String renderNullsOrdering(boolean nullsFirst) throws UnsupportedSQLFeatureException {
        throw new UnsupportedSQLFeatureException("MySQL does not implement NULLS FIRST or NULLS LAST in the ORDER BY clause.");
    }
}

