/*
 * Decompiled with CFR 0.152.
 */
package highfive.model;

import highfive.exceptions.JavaTypeNotSupportedException;
import highfive.model.Serializer;
import highfive.utils.Utl;
import java.util.HashMap;
import java.util.Map;

public class TypeSolver {
    private Map<String, Serializer<?>> rules = new HashMap();

    public void add(String type, String serializerName) throws JavaTypeNotSupportedException {
        if (Utl.empty(type)) {
            throw new RuntimeException("Cannot add a rule with no type.");
        }
        if (Utl.empty(serializerName)) {
            throw new RuntimeException("Cannot add a rule with no serializer name.");
        }
        String javaType = serializerName.trim().toLowerCase();
        Serializer<?> s = Serializer.find(javaType);
        if (s == null) {
            throw new JavaTypeNotSupportedException("Java type '" + javaType + "' is not supported in the type rules.");
        }
        this.rules.put(type.trim().toLowerCase(), s);
    }

    public Serializer<?> resolve(String renderedType) {
        if (renderedType == null) {
            return null;
        }
        return this.rules.get(renderedType.toLowerCase());
    }
}

