/*
 * Decompiled with CFR 0.152.
 */
package highfive.commands;

import highfive.commands.DualDataSourceCommand;
import highfive.exceptions.CouldNotCopyDataException;
import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.InvalidSchemaException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.model.Column;
import highfive.model.Identifier;
import highfive.model.Table;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CopyCommand
extends DualDataSourceCommand {
    private static final int MAX_BATCH_EXCEPTIONS_TO_DISPLAY = 3;

    public CopyCommand(String sourceDatasourceName, String destDatasourceName) throws InvalidConfigurationException, SQLException, UnsupportedDatabaseTypeException {
        super("Copy Data", sourceDatasourceName, destDatasourceName);
    }

    @Override
    public void execute() throws SQLException, InvalidSchemaException, CouldNotCopyDataException, UnsupportedDatabaseTypeException {
        class ColumnPair {
            Column source;
            Column dest;

            ColumnPair() {
            }
        }
        ArrayList<String> errors = new ArrayList<String>();
        List<Identifier> stables = this.ds.getDialect().listTablesNames();
        Map<String, Identifier> sid = stables.stream().collect(Collectors.toMap(t -> t.getGenericName(), t -> t));
        List<Identifier> dtables = this.ds2.getDialect().listTablesNames();
        Map<String, Identifier> did = dtables.stream().collect(Collectors.toMap(t -> t.getGenericName(), t -> t));
        if (this.ds2.getReadOnly()) {
            errors.add("Could not copy data to the datasource '" + this.ds2.getName() + "' since it's configured as read-only. To copy data to it, add/set the property '" + this.ds2.getName() + ".readonly' to 'false'.");
        }
        this.info("Destination Database - Initial Row Count:");
        boolean allEmpty = true;
        for (Identifier t2 : dtables) {
            String tid = this.ds2.getDialect().renderSQLTableIdentifier(t2);
            String sql = "select count(*) from " + tid;
            PreparedStatement ps = this.ds2.getConnection().prepareStatement(sql);
            Throwable throwable = null;
            try {
                ResultSet rs = ps.executeQuery();
                Throwable throwable2 = null;
                try {
                    if (!rs.next()) continue;
                    long count = rs.getLong(1);
                    if (count > 0L) {
                        allEmpty = false;
                    }
                    this.info("  " + t2.getGenericName() + ": " + DF.format(count) + " rows" + (count == 0L ? "" : " -- not empty"));
                }
                catch (Throwable count) {
                    throwable2 = count;
                    throw count;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable2 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable count) {
                            throwable2.addSuppressed(count);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (Throwable rs) {
                throwable = rs;
                throw rs;
            }
            finally {
                if (ps == null) continue;
                if (throwable != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable rs) {
                        throwable.addSuppressed(rs);
                    }
                    continue;
                }
                ps.close();
            }
        }
        if (!allEmpty) {
            errors.add("Some destination tables are not empty. Please make sure they are empty before copying the data.");
        }
        this.info(" ");
        this.info("Preparing data copy:");
        class TablePair {
            Identifier source;
            Identifier dest;
            List<ColumnPair> columns = new ArrayList<ColumnPair>();

            TablePair() {
            }
        }
        ArrayList<TablePair> pairs = new ArrayList<TablePair>();
        Iterator<String> it = sid.keySet().iterator();
        while (it.hasNext()) {
            String gname = it.next();
            Identifier dt = did.get(gname);
            if (dt == null) {
                errors.add("Found table '" + gname + "' in the source database, but not in the destination database");
                continue;
            }
            TablePair pair = new TablePair();
            pair.source = sid.get(gname);
            pair.dest = dt;
            pairs.add(pair);
            it.remove();
            did.remove(gname);
        }
        if (!did.isEmpty()) {
            errors.add("Found table '" + did.keySet().iterator().next() + "' in the destination database, but not in the source database");
        }
        for (TablePair pair : pairs) {
            Table st = this.ds.getDialect().getTableMetaData(pair.source);
            Map<String, Column> scols = st.getColumns().stream().collect(Collectors.toMap(c -> c.getName(), c -> c));
            Table dt = this.ds2.getDialect().getTableMetaData(pair.dest);
            Map<String, Column> dcols = dt.getColumns().stream().collect(Collectors.toMap(c -> c.getName(), c -> c));
            Iterator<Object> it2 = scols.keySet().iterator();
            while (it2.hasNext()) {
                String name = it2.next();
                Column sc = scols.get(name);
                Column dc = dcols.get(name);
                if (dc == null) {
                    errors.add("Found column '" + name + "' in table '" + pair.source.getGenericName() + "' in the source database, but not in the destination database");
                    continue;
                }
                ColumnPair cpair = new ColumnPair();
                if (!sc.getSerializer().getClass().equals(dc.getSerializer().getClass())) {
                    errors.add("Cannot copy data of column '" + name + "' in table '" + pair.source.getGenericName() + "': it has different data types: '" + sc.getSerializer().getName() + "' in the source database, and '" + dc.getSerializer().getName() + "' in the destination database");
                    continue;
                }
                cpair.source = sc;
                cpair.dest = dc;
                pair.columns.add(cpair);
                it2.remove();
                dcols.remove(name);
            }
            if (!dcols.isEmpty()) {
                errors.add("Found column '" + dcols.keySet().iterator().next() + "' in table '" + pair.source.getGenericName() + "' in the destination database, but not in the source database");
            }
            for (ColumnPair cp : pair.columns) {
                if (cp.source.getSerializer().getClass().equals(cp.dest.getSerializer().getClass())) continue;
                errors.add("Found column '" + dcols.keySet().iterator().next() + "' in table '" + pair.source.getGenericName() + "' in the destination database, but not in the source database");
            }
        }
        if (!errors.isEmpty()) {
            errors.stream().forEach(e -> this.error("  - " + e));
            throw new CouldNotCopyDataException("Cannot copy data due to validation errors (" + errors.size() + ") -- Copy aborted.");
        }
        this.info("  All validation passed.");
        this.info(" ");
        long grandTotalRows = 0L;
        for (TablePair pair : pairs) {
            this.info("Copying table " + pair.source.renderSQL() + ":");
            String stid = this.ds.getDialect().renderSQLTableIdentifier(pair.source);
            String pkNames = pair.columns.stream().filter(c -> c.source.getPKPosition() != null).sorted((a, b) -> a.source.getPKPosition().compareTo(b.source.getPKPosition())).map(c -> this.ds.getDialect().escapeIdentifierAsNeeded(c.source.getCanonicalName())).collect(Collectors.joining(", "));
            String snames = pair.columns.stream().map(c -> this.ds.getDialect().escapeIdentifierAsNeeded(c.source.getCanonicalName())).collect(Collectors.joining(", "));
            String select = "select " + snames + " from " + stid;
            String dtid = this.ds2.getDialect().renderSQLTableIdentifier(pair.dest);
            String dnames = pair.columns.stream().map(c -> this.ds2.getDialect().escapeIdentifierAsNeeded(c.dest.getCanonicalName())).collect(Collectors.joining(", "));
            String insert = "insert into " + dtid + " (" + dnames + ") values (" + pair.columns.stream().map(x -> "?").collect(Collectors.joining(", ")) + ")";
            this.ds.getConnection().setAutoCommit(this.ds.getSelectAutoCommit());
            PreparedStatement selectPS = this.ds.getConnection().prepareStatement(select, 1003, 1007);
            Throwable throwable = null;
            try {
                PreparedStatement insertPS = this.ds2.getConnection().prepareStatement(insert, 1003, 1007);
                Throwable throwable3 = null;
                try {
                    ResultSet rs = selectPS.executeQuery();
                    Throwable throwable4 = null;
                    try {
                        int logCount = 0;
                        long currentBatch = 0L;
                        int rowsCount = 0;
                        while (rs.next()) {
                            int col = 1;
                            for (ColumnPair cp : pair.columns) {
                                Column c2 = cp.source;
                                try {
                                    c2.getSerializer().read(rs, col);
                                }
                                catch (SQLException e2) {
                                    this.error("The JDBC driver could not read the value of column '" + c2.getCanonicalName() + "' on table '" + pair.source.getCanonicalName() + "' as a '" + c2.getSerializer().getName() + "' value. The error happened in row #" + DF.format(rowsCount) + 1 + " when the table is sorted by the primary key (" + pkNames + ").");
                                    throw e2;
                                }
                                catch (RuntimeException e3) {
                                    this.error("Could not serialize the value for column '" + c2.getCanonicalName() + "' on table '" + pair.source.getCanonicalName() + "'. The error happened in row #" + DF.format(rowsCount) + 1 + " when the table is sorted by the primary key (" + pkNames + "). Is '" + c2.getSerializer().getClass().getSimpleName() + "' the correct serializer for this column?");
                                    throw e3;
                                }
                                c2.getSerializer().set(insertPS, col);
                                ++col;
                            }
                            insertPS.addBatch();
                            if (++currentBatch >= this.ds2.getInsertBatchSize()) {
                                insertPS.executeBatch();
                                currentBatch = 0L;
                            }
                            ++rowsCount;
                            if (++logCount >= 50000) {
                                this.info("  " + DF.format(rowsCount) + " rows copied");
                                logCount = 0;
                            }
                            if (this.ds2.getMaxRows() == null || (long)rowsCount < this.ds2.getMaxRows()) continue;
                            this.info("  - Limit of " + DF.format(this.ds2.getMaxRows()) + " rows (max.rows) reached when copying this table -- moving on to the next table.");
                            break;
                        }
                        if (currentBatch > 0L) {
                            try {
                                insertPS.executeBatch();
                            }
                            catch (SQLException e4) {
                                this.error("Could not copy data to table '" + pair.dest.getCanonicalName() + "'.");
                                this.error("-- SQL insert statement: " + insert);
                                SQLException oe = e4;
                                int cnt = 0;
                                e4 = e4.getNextException();
                                while (e4 != null) {
                                    if (++cnt <= 3) {
                                        e4.printStackTrace();
                                        e4 = e4.getNextException();
                                        continue;
                                    }
                                    e4 = null;
                                }
                                if (cnt > 3) {
                                    this.info("-- Abridged: showing only the first 3 exception(s) of the batch insert.");
                                }
                                throw oe;
                            }
                        }
                        this.info("  " + DF.format(rowsCount) + " row(s) copied");
                        grandTotalRows += (long)rowsCount;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable4 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable6) {
                                throwable4.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable7) {
                    throwable3 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (insertPS == null) continue;
                    if (throwable3 != null) {
                        try {
                            insertPS.close();
                        }
                        catch (Throwable throwable8) {
                            throwable3.addSuppressed(throwable8);
                        }
                        continue;
                    }
                    insertPS.close();
                }
            }
            catch (Throwable throwable9) {
                throwable = throwable9;
                throw throwable9;
            }
            finally {
                if (selectPS == null) continue;
                if (throwable != null) {
                    try {
                        selectPS.close();
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                    }
                    continue;
                }
                selectPS.close();
            }
        }
        this.info("Copy complete -- Grand total of " + DF.format(grandTotalRows) + " row(s) copied");
    }
}

