/*
 * Decompiled with CFR 0.152.
 */
package highfive.model;

import highfive.exceptions.InvalidConfigurationException;
import highfive.exceptions.JavaTypeNotSupportedException;
import highfive.exceptions.UnsupportedDatabaseTypeException;
import highfive.model.ColumnFilter;
import highfive.model.Dialect;
import highfive.model.DialectFactory;
import highfive.model.DriverShim;
import highfive.model.TableFilter;
import highfive.model.TableHashingMember;
import highfive.model.TableHashingOrdering;
import highfive.model.TypeSolver;
import highfive.utils.Name;
import highfive.utils.Utl;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class DataSource {
    private static final String CONFIG_FILE = "application.properties";
    private static final long DEFAULT_INSERT_BATCH_SIZE = 100L;
    private String name;
    private String driverJAR;
    private String driverClass;
    private String url;
    private String username;
    private String password;
    private String catalog;
    private String schema;
    private String removeTablePrefix;
    private boolean selectAutoCommit;
    private boolean readOnly;
    private TableFilter tableFilter;
    private ColumnFilter columnFilter;
    private TypeSolver solver;
    private Long maxRows;
    private boolean logHashingValues;
    private long insertBatchSize;
    private LinkedHashMap<String, TableHashingOrdering> hashingOrderings;
    private String hashFileName;
    private Dialect dialect;
    private Connection conn;
    private String database;
    private String jdbcDriver;
    private static final SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public DataSource(String name, String driverJAR, String driverClass, String url, String username, String password, String catalog, String schema, String removeTablePrefix, Boolean declaredSelectAutoCommit, boolean readOnly, TableFilter tableFilter, ColumnFilter columnFilter, Long maxRows, boolean logHashingValues, long insertBatchSize, TypeSolver solver, LinkedHashMap<String, TableHashingOrdering> hashingOrderings) throws SQLException, UnsupportedDatabaseTypeException {
        Boolean defaultAutoCommit;
        URL jarURL;
        this.name = name;
        this.driverJAR = driverJAR;
        this.driverClass = driverClass;
        this.url = url;
        this.username = username;
        this.password = password;
        this.catalog = catalog;
        this.schema = schema;
        this.removeTablePrefix = removeTablePrefix;
        this.readOnly = readOnly;
        this.tableFilter = tableFilter;
        this.columnFilter = columnFilter;
        this.maxRows = maxRows;
        this.logHashingValues = logHashingValues;
        this.insertBatchSize = insertBatchSize;
        this.solver = solver;
        this.hashingOrderings = hashingOrderings;
        this.hashFileName = name + ".hash";
        File myJar = new File(this.driverJAR);
        if (!myJar.exists()) {
            this.error("Could not find the JDBC driver jar library '" + this.driverJAR + "': file not found.");
            throw new SQLException("JDBC driver jar library not found.");
        }
        try {
            jarURL = myJar.toURI().toURL();
        }
        catch (MalformedURLException e) {
            this.error("Could not load the JDBC driver jar library: " + e.getMessage());
            throw new SQLException(e.getMessage());
        }
        URLClassLoader child = new URLClassLoader(new URL[]{jarURL}, this.getClass().getClassLoader());
        try {
            Driver dx = (Driver)Class.forName(this.driverClass, true, child).getConstructor(new Class[0]).newInstance(new Object[0]);
            DriverManager.registerDriver(new DriverShim(dx));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.error("Could not load the JDBC driver jar library: " + e.getMessage());
            throw new SQLException(e.getClass().getSimpleName() + ": " + e.getMessage());
        }
        this.conn = null;
        try {
            this.conn = DriverManager.getConnection(this.url, this.username, this.password);
        }
        catch (SQLException e) {
            this.error("Could not connect to database: " + e.getMessage());
            throw e;
        }
        DatabaseMetaData dm = this.conn.getMetaData();
        this.database = dm.getDatabaseProductName() + " " + dm.getDatabaseProductVersion();
        this.jdbcDriver = dm.getDriverName() + " " + dm.getDriverVersion() + " - implements JDBC " + dm.getJDBCMajorVersion() + "." + dm.getJDBCMinorVersion();
        this.dialect = DialectFactory.getDialect(this);
        this.selectAutoCommit = declaredSelectAutoCommit != null ? declaredSelectAutoCommit : ((defaultAutoCommit = this.dialect.getDefaultAutoCommit()) != null ? defaultAutoCommit : true);
    }

    public static DataSource load(String name) throws InvalidConfigurationException, SQLException, UnsupportedDatabaseTypeException {
        String[] parts;
        String[] parts2;
        Properties props = new Properties();
        if (name == null || name.trim().isEmpty()) {
            throw new InvalidConfigurationException("Must provide a non-empty db name.");
        }
        if (!name.matches("^[A-Za-z0-9_]+$")) {
            throw new InvalidConfigurationException("The db name can only include letter, digits, and underscores, but found other characters.");
        }
        try {
            props.load(new FileReader(new File(CONFIG_FILE)));
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Could not read configuration file 'application.properties': " + e.getMessage());
        }
        String driverJAR = DataSource.readMandatory(props, name + ".driver.jar");
        String driverClass = DataSource.readMandatory(props, name + ".driver.class");
        String url = DataSource.readMandatory(props, name + ".url");
        String username = DataSource.readMandatory(props, name + ".username");
        String password = props.getProperty(name + ".password");
        String catalog = props.getProperty(name + ".catalog");
        String schema = DataSource.readMandatory(props, name + ".schema");
        String tableFilterList = props.getProperty(name + ".table.filter");
        String removeTablePrefix = props.getProperty(name + ".remove.table.prefix");
        removeTablePrefix = Utl.empty(removeTablePrefix) ? null : removeTablePrefix.toLowerCase();
        String columnFilterList = props.getProperty(name + ".column.filter");
        String sMaxRows = props.getProperty(name + ".max.rows");
        String sLogHashingValues = props.getProperty(name + ".log.hashing.values");
        String sInsertBatchSize = props.getProperty(name + ".insert.batch.size");
        String typeRules = props.getProperty(name + ".type.rules");
        Boolean declaredSelectAutoCommit = null;
        String sDeclaredAutoCommit = props.getProperty(name + ".select.autocommit");
        if (!Utl.empty(sDeclaredAutoCommit)) {
            if ("false".equals(sDeclaredAutoCommit)) {
                declaredSelectAutoCommit = false;
            } else if ("true".equals(sDeclaredAutoCommit)) {
                declaredSelectAutoCommit = true;
            } else {
                throw new InvalidConfigurationException("If the property '" + name + ".select.autocommit" + "' is specified it must be either 'true' or 'false', but found '" + sDeclaredAutoCommit + "'.");
            }
        }
        boolean readOnly = true;
        String sReadOnly = props.getProperty(name + ".readonly");
        if (!Utl.empty(sReadOnly)) {
            if ("false".equals(sReadOnly)) {
                readOnly = false;
            } else if ("true".equals(sReadOnly)) {
                readOnly = true;
            } else {
                throw new InvalidConfigurationException("If the property '" + name + ".readonly" + "' is specified it must be either 'true' or 'false', but found '" + sReadOnly + "'.");
            }
        }
        Set<String> allowedTables = new HashSet<String>();
        if (tableFilterList != null && !tableFilterList.trim().isEmpty() && (parts2 = tableFilterList.split(",")) != null) {
            allowedTables = Arrays.stream(parts2).map(t -> Name.lower(t.trim())).collect(Collectors.toSet());
        }
        TableFilter tableFilter = new TableFilter(allowedTables);
        Set<String> allowedColumns = new HashSet<String>();
        if (columnFilterList != null && !columnFilterList.trim().isEmpty() && (parts = columnFilterList.split(",")) != null) {
            allowedColumns = Arrays.stream(parts).map(t -> Name.lower(t.trim())).collect(Collectors.toSet());
        }
        ColumnFilter columnFilter = new ColumnFilter(allowedColumns);
        Long maxRows = null;
        if (sMaxRows != null && !sMaxRows.trim().isEmpty()) {
            try {
                maxRows = Long.parseLong(sMaxRows);
                if (maxRows < 1L) {
                    throw new InvalidConfigurationException("If the property '" + name + ".max.rows" + "' is specified, if must be a number greater than zero, but found '" + sMaxRows + "'.");
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("If the property '" + name + ".max.rows" + "' is specified, if must be a number greater than zero, but found '" + sMaxRows + "'.");
            }
        }
        boolean logHashingValues = false;
        if (!Utl.empty(sLogHashingValues)) {
            if ("false".equals(sLogHashingValues)) {
                logHashingValues = false;
            } else if ("true".equals(sLogHashingValues)) {
                logHashingValues = true;
            } else {
                throw new InvalidConfigurationException("If the property '" + name + ".log.hashing.values" + "' is specified it must be either 'true' or 'false', but found '" + sReadOnly + "'.");
            }
        }
        LinkedHashMap<String, TableHashingOrdering> hashingOrderings = new LinkedHashMap<String, TableHashingOrdering>();
        String sSortingColumns = props.getProperty(name + ".hashing.ordering");
        if (!Utl.empty(sSortingColumns)) {
            String[] tparts;
            for (String tp : tparts = sSortingColumns.split(";")) {
                String[] sm;
                int idx = tp.indexOf(":");
                if (idx == -1) {
                    throw new InvalidConfigurationException("If the property '" + name + ".hashing.ordering" + "' is specified, it must be a semicolon-separated list of table sorting rules, " + "where each rule takes the form '<table>:<column>,<column>,...'");
                }
                String tname = tp.substring(0, idx).toLowerCase().trim();
                TableHashingOrdering tho = new TableHashingOrdering(tname);
                if (hashingOrderings.containsKey(tname)) {
                    throw new InvalidConfigurationException("Duplicate table name '" + tname + "' found in the property '" + name + ".hashing.ordering" + "'. When specified, this property must be a semicolon-separated list of table sorting rules, " + "where each rule takes the form '<table>:<column>,<column>,...'");
                }
                hashingOrderings.put(tho.getTableName(), tho);
                String smembers = tp.substring(idx + 1).trim().toLowerCase();
                if (smembers.equals("*")) continue;
                for (String s : sm = smembers.split(",")) {
                    TableHashingMember m = DataSource.parseOrderingMember(name, tname, s);
                    if (tho.getMembers().containsKey(m.getGenericColumnName())) {
                        throw new InvalidConfigurationException("Duplicate column name '" + m.getGenericColumnName() + "' found in the property '" + name + ".hashing.ordering" + "' for table '" + tname + "'.");
                    }
                    tho.getMembers().put(m.getGenericColumnName(), m);
                }
            }
        }
        long insertBatchSize = 100L;
        if (!Utl.empty(sInsertBatchSize)) {
            try {
                insertBatchSize = Long.parseLong(sInsertBatchSize);
                if (insertBatchSize < 1L) {
                    throw new InvalidConfigurationException("If the property '" + name + ".insert.batch.size" + "' is specified, if must be a number greater than zero, but found '" + sInsertBatchSize + "'.");
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("If the property '" + name + ".insert.batch.size" + "' is specified, if must be a number greater than zero, but found '" + sInsertBatchSize + "'.");
            }
        }
        TypeSolver solver = new TypeSolver();
        if (!Utl.empty(typeRules)) {
            String[] parts3;
            for (String p : parts3 = typeRules.split(";")) {
                int c = p.indexOf(58);
                if (c == -1) {
                    throw new InvalidConfigurationException("If the property '" + name + ".type.rules" + "' is specified, if must be a semicolon-separated list of rules; each rule takes the form 'dbtype:javatype'. Invalid value: " + typeRules);
                }
                String dt = p.substring(0, c);
                String jt = p.substring(c + 1);
                try {
                    solver.add(dt, jt);
                }
                catch (JavaTypeNotSupportedException e) {
                    throw new InvalidConfigurationException("Invalid configuration: " + e.getMessage());
                }
            }
        }
        return new DataSource(name, driverJAR, driverClass, url, username, password, catalog, schema, removeTablePrefix, declaredSelectAutoCommit, readOnly, tableFilter, columnFilter, maxRows, logHashingValues, insertBatchSize, solver, hashingOrderings);
    }

    private static TableHashingMember parseOrderingMember(String dsName, String table, String s) throws InvalidConfigurationException {
        String[] parts = s.split("\\/");
        String p1 = parts[0].trim().toLowerCase();
        if (Utl.empty(p1)) {
            throw new InvalidConfigurationException("Empty column name for table '" + table + "' found in the property '" + dsName + ".hashing.ordering" + "'. When specified, this property must be a semicolon-separated list of table sorting rules, " + "where each rule takes the form '<table>:<column>,<column>,...'");
        }
        if (parts.length == 1) {
            return new TableHashingMember(p1, true, null);
        }
        if (parts.length == 2) {
            String p2 = parts[1].trim().toLowerCase();
            if (p2.equals("desc")) {
                return new TableHashingMember(p1, false, null);
            }
            if (p2.equals("nf")) {
                return new TableHashingMember(p1, true, true);
            }
            if (p2.equals("nl")) {
                return new TableHashingMember(p1, true, false);
            }
            throw new InvalidConfigurationException("Invalid ordering column option '" + p2 + "' for table '" + table + "' in the property '" + dsName + ".hashing.ordering" + "'. Valid ordering column options are: desc, nf, nl");
        }
        if (parts.length == 3) {
            String p2 = parts[1].trim().toLowerCase();
            if (!p2.equals("desc")) {
                throw new InvalidConfigurationException("Invalid ordering column option '" + p2 + "' for table '" + table + "' in the property '" + dsName + ".hashing.ordering" + "'. When three ordering column options are specified, the second one must be 'desc'");
            }
            String p3 = parts[2].trim().toLowerCase();
            if (p3.equals("nf")) {
                return new TableHashingMember(p1, false, true);
            }
            if (p3.equals("nl")) {
                return new TableHashingMember(p1, false, false);
            }
            throw new InvalidConfigurationException("Invalid ordering column option '" + p3 + "' for table '" + table + "' in the property '" + dsName + ".hashing.ordering" + "'. When three ordering column options are specified, the third one one must be either 'nf' or 'nl'");
        }
        throw new InvalidConfigurationException("Invalid ordering for table '" + table + "' in the the property '" + dsName + ".hashing.ordering" + "'. When specified, this property must be a semicolon-separated list of table sorting rules, " + "where each rule takes the form '<table>:<column>,<column>,...'");
    }

    private static String readMandatory(Properties props, String name) throws InvalidConfigurationException {
        String value = props.getProperty(name);
        if (value == null) {
            throw new InvalidConfigurationException("Could not find property '" + name + "'.");
        }
        return value;
    }

    public void show(String datasourceName) {
        this.show(datasourceName, false);
    }

    public void show(String datasourceName, boolean forInserting) {
        DataSource.info(datasourceName + ":");
        DataSource.info("  name: " + this.name);
        DataSource.info("  dialect: " + this.getDialect().getName());
        DataSource.info("  url: " + this.url);
        DataSource.info("  database: " + this.database);
        DataSource.info("  JDBC Driver: " + this.jdbcDriver);
        DataSource.info("  username: " + this.username);
        DataSource.info("  catalog: " + (this.catalog == null ? "" : this.catalog));
        DataSource.info("  schema: " + this.schema);
        if (this.tableFilter.declared()) {
            DataSource.info("  table filter: " + this.tableFilter.render());
        }
        if (this.removeTablePrefix != null) {
            DataSource.info("  remove table prefix: " + this.removeTablePrefix);
        }
        if (this.columnFilter.declared()) {
            DataSource.info("  column filter: " + this.columnFilter.render());
        }
        if (this.maxRows != null) {
            DataSource.info("  max rows to read: " + this.maxRows);
        }
        DataSource.info("  log hashing values: " + this.logHashingValues);
        if (forInserting) {
            DataSource.info("  insert batch size: " + this.insertBatchSize);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDriverJAR() {
        return this.driverJAR;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getURL() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getRemoveTablePrefix() {
        return this.removeTablePrefix;
    }

    public TableFilter getTableFilter() {
        return this.tableFilter;
    }

    public ColumnFilter getColumnFilter() {
        return this.columnFilter;
    }

    public Long getMaxRows() {
        return this.maxRows;
    }

    public boolean getLogHashingValues() {
        return this.logHashingValues;
    }

    public long getInsertBatchSize() {
        return this.insertBatchSize;
    }

    public TypeSolver getTypeSolver() {
        return this.solver;
    }

    public String getHashFileName() {
        return this.hashFileName;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public boolean getSelectAutoCommit() {
        return this.selectAutoCommit;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public LinkedHashMap<String, TableHashingOrdering> getHashingOrderings() {
        return this.hashingOrderings;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getJDBCDriver() {
        return this.jdbcDriver;
    }

    public Connection getConnection() {
        return this.conn;
    }

    protected static void info(String s) {
        System.out.println(DF.format(new Date()) + " INFO  - " + s);
    }

    protected void error(String s) {
        System.out.println(DF.format(new Date()) + " ERROR - " + s);
    }

    protected void error(Throwable e) {
        System.out.print(DF.format(new Date()) + " ERROR - ");
        e.printStackTrace(System.out);
    }
}

