/*
 * Decompiled with CFR 0.152.
 */
package highfive.serializers;

import highfive.model.Serializer;
import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LongSerializer
extends Serializer<Long> {
    private static ByteBuffer LB = ByteBuffer.allocate(8);
    private Long value;

    @Override
    public byte[] read(ResultSet rs, int ordinal) throws SQLException {
        this.value = rs.getLong(ordinal);
        if (rs.wasNull()) {
            this.value = null;
            return null;
        }
        LB.putLong(0, this.value);
        return LB.array();
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement ps, int ordinal) throws SQLException {
        if (this.value == null) {
            ps.setNull(ordinal, -5);
        } else {
            ps.setLong(ordinal, this.value);
        }
    }
}

